/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.IFurnaceRecipes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.UpdateClientWithRecipesMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="minecolonies")
@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FurnaceRecipes
implements IFurnaceRecipes {
    private Map<ItemStorage, RecipeStorage> recipes = new HashMap<ItemStorage, RecipeStorage>();
    private Map<ItemStorage, RecipeStorage> reverseRecipes = new HashMap<ItemStorage, RecipeStorage>();
    public static FurnaceRecipes instance;

    private void loadRecipes(MinecraftServer server) {
        server.func_199529_aN().func_215366_a(IRecipeType.field_222150_b).values().forEach(recipe -> {
            NonNullList list = recipe.func_192400_c();
            if (list.size() == 1) {
                for (ItemStack smeltable : ((Ingredient)list.get(0)).func_193365_a()) {
                    RecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)smeltable), 1, recipe.func_77571_b(), Blocks.field_150460_al});
                    this.recipes.put(storage.getCleanedInput().get(0), storage);
                    ItemStack output = recipe.func_77571_b().func_77946_l();
                    output.func_190920_e(1);
                    this.reverseRecipes.put(new ItemStorage(output), storage);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartedEvent event) {
        instance.loadRecipes(event.getServer());
        FurnaceRecipes.loadUtilityPredicates();
    }

    private static void loadUtilityPredicates() {
        ItemStackUtils.ISFOOD = itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b().func_219971_r();
        ItemStackUtils.IS_SMELTABLE = itemStack -> ItemStackUtils.isEmpty(instance.getSmeltingResult((ItemStack)itemStack)) == false;
        ItemStackUtils.CAN_EAT = itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b().func_219971_r() && !ItemStackUtils.ISFOOD.test(instance.getSmeltingResult((ItemStack)itemStack));
        ItemStackUtils.ISCOOKABLE = itemStack -> ItemStackUtils.ISFOOD.test(instance.getSmeltingResult((ItemStack)itemStack));
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerAboutToStartEvent event) {
        instance = new FurnaceRecipes();
        FurnaceRecipes.loadUtilityPredicates();
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            Network.getNetwork().sendToPlayer(new UpdateClientWithRecipesMessage(FurnaceRecipes.instance.recipes), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @Override
    public void setMap(Map<ItemStorage, RecipeStorage> map) {
        this.recipes = map;
        if (ItemStackUtils.ISFOOD == null) {
            FurnaceRecipes.loadUtilityPredicates();
        }
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack itemStack) {
        RecipeStorage storage = this.recipes.getOrDefault(new ItemStorage(itemStack), null);
        if (storage != null) {
            return storage.getPrimaryOutput();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public RecipeStorage getFirstSmeltingRecipeByResult(Predicate<ItemStack> stackPredicate) {
        Optional<ItemStorage> index = this.reverseRecipes.keySet().stream().filter(item -> stackPredicate.test(item.getItemStack())).findFirst();
        if (index.isPresent()) {
            return this.reverseRecipes.getOrDefault(index.get(), null);
        }
        return null;
    }

    public static FurnaceRecipes getInstance() {
        if (instance == null) {
            instance = new FurnaceRecipes();
        }
        return instance;
    }

    public boolean loaded() {
        return !this.recipes.isEmpty();
    }
}

