/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.biome.surface;

import com.terraforged.api.biome.surface.Surface;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.biome.surface.builder.Delegate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class SurfaceManager {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ResourceLocation, Surface> surfaces = new HashMap<ResourceLocation, Surface>();

    public Surface getSurface(Biome biome) {
        this.lock.readLock().lock();
        Surface surface = this.surfaces.get(biome.getRegistryName());
        this.lock.readLock().unlock();
        return surface;
    }

    public Surface getOrCreateSurface(Biome biome) {
        Surface surface = this.getSurface(biome);
        if (surface == null) {
            surface = Delegate.FUNC.apply(biome);
            this.replace(biome, surface);
        }
        return surface;
    }

    public SurfaceManager replace(Biome biome, Surface surface) {
        this.lock.writeLock().lock();
        this.surfaces.put(biome.getRegistryName(), surface);
        this.lock.writeLock().unlock();
        return this;
    }

    public SurfaceManager replace(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.replace(biome, surface);
        }
        return this;
    }

    public SurfaceManager prepend(Biome biome, Surface surface) {
        Surface result = surface.then(this.getOrCreateSurface(biome));
        return this.replace(biome, result);
    }

    public SurfaceManager prepend(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.prepend(biome, surface);
        }
        return this;
    }

    public SurfaceManager append(Biome biome, Surface surface) {
        Surface result = this.getOrCreateSurface(biome).then(surface);
        return this.replace(biome, result);
    }

    public SurfaceManager append(Surface surface, Biome ... biomes) {
        for (Biome biome : biomes) {
            this.append(biome, surface);
        }
        return this;
    }

    public Surface getSurface(SurfaceContext context) {
        if (context.biome == context.cached.biome) {
            return context.cached.surface;
        }
        context.cached.biome = context.biome;
        context.cached.surface = this.getOrCreateSurface(context.biome);
        return context.cached.surface;
    }
}

