/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.material.layer;

import com.terraforged.n2d.util.NoiseUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;

public class LayerMaterial {
    public static final BlockState NONE = Blocks.field_150350_a.func_176223_P();
    private final int min;
    private final int max;
    private final BlockState fullState;
    private final BlockState layerState;
    private final IProperty<Integer> layerProperty;

    private LayerMaterial(BlockState fullState, BlockState layerState, IProperty<Integer> layerProperty) {
        this.layerProperty = layerProperty;
        this.min = LayerMaterial.min(layerProperty);
        this.max = LayerMaterial.max(layerProperty);
        this.layerState = layerState;
        this.fullState = fullState;
    }

    public Block getLayerType() {
        return this.layerState.func_177230_c();
    }

    public BlockState getFull() {
        return this.fullState;
    }

    public BlockState getState(float value) {
        return this.getState(this.getLevel(value));
    }

    public BlockState getState(int level) {
        if (level < this.min) {
            return NONE;
        }
        if (level >= this.max) {
            return this.fullState;
        }
        return (BlockState)this.layerState.func_206870_a(this.layerProperty, (Comparable)Integer.valueOf(level));
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getLevel(float depth) {
        if (depth > 1.0f) {
            depth = this.getDepth(depth);
        } else if (depth < 0.0f) {
            depth = 0.0f;
        }
        return NoiseUtil.round(depth * (float)this.max);
    }

    public float getDepth(float height) {
        return height - (float)((int)height);
    }

    private static int min(IProperty<Integer> property) {
        return property.func_177700_c().stream().min(Integer::compareTo).orElse(0);
    }

    private static int max(IProperty<Integer> property) {
        return property.func_177700_c().stream().max(Integer::compareTo).orElse(0);
    }

    public static LayerMaterial of(Block block) {
        return LayerMaterial.of(block, (IProperty<Integer>)BlockStateProperties.field_208129_ad);
    }

    public static LayerMaterial of(Block block, IProperty<Integer> property) {
        return LayerMaterial.of(block.func_176223_P(), block.func_176223_P(), property);
    }

    public static LayerMaterial of(Block full, Block layer) {
        return LayerMaterial.of(full.func_176223_P(), layer.func_176223_P());
    }

    public static LayerMaterial of(Block full, Block layer, IProperty<Integer> property) {
        return LayerMaterial.of(full.func_176223_P(), layer.func_176223_P(), property);
    }

    public static LayerMaterial of(BlockState layer) {
        return LayerMaterial.of(layer, (IProperty<Integer>)BlockStateProperties.field_208129_ad);
    }

    public static LayerMaterial of(BlockState layer, IProperty<Integer> property) {
        return LayerMaterial.of((BlockState)layer.func_206870_a(property, (Comparable)Integer.valueOf(LayerMaterial.max(property))), layer);
    }

    public static LayerMaterial of(BlockState full, BlockState layer) {
        return LayerMaterial.of(full, layer, (IProperty<Integer>)BlockStateProperties.field_208129_ad);
    }

    public static LayerMaterial of(BlockState full, BlockState layer, IProperty<Integer> property) {
        return new LayerMaterial(full, layer, property);
    }
}

