/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.cell;

import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.concurrent.pool.ObjectPool;
import com.terraforged.core.concurrent.thread.context.ContextualThread;
import com.terraforged.world.biome.BiomeType;
import com.terraforged.world.terrain.Terrain;

public class Cell {
    private static final Cell defaults = new Cell();
    private static final Cell EMPTY = new Cell(){

        @Override
        public boolean isAbsent() {
            return true;
        }
    };
    private static final ObjectPool<Cell> POOL = new ObjectPool<Cell>(32, Cell::new);
    public int continentX;
    public int continentZ;
    public float continentEdge;
    public float continentIdentity;
    public float terrainRegionEdge;
    public float terrainRegionIdentity;
    public Terrain terrain = Terrain.NONE;
    public float biomeEdge = 1.0f;
    public float biomeIdentity;
    public float riverMask = 1.0f;
    public boolean erosionMask = false;
    public float value;
    public float moisture = 0.5f;
    public float temperature = 0.5f;
    public BiomeType biomeType = BiomeType.GRASSLAND;
    public float macroNoise;
    public float gradient;
    public float erosion;
    public float sediment;

    public void copy(Cell other) {
        this.value = other.value;
        this.continentIdentity = other.continentIdentity;
        this.continentEdge = other.continentEdge;
        this.terrainRegionIdentity = other.terrainRegionIdentity;
        this.terrainRegionEdge = other.terrainRegionEdge;
        this.biomeIdentity = other.biomeIdentity;
        this.biomeEdge = other.biomeEdge;
        this.riverMask = other.riverMask;
        this.erosionMask = other.erosionMask;
        this.moisture = other.moisture;
        this.temperature = other.temperature;
        this.macroNoise = other.macroNoise;
        this.gradient = other.gradient;
        this.erosion = other.erosion;
        this.sediment = other.sediment;
        this.biomeType = other.biomeType;
        this.terrain = other.terrain;
    }

    public void reset() {
        this.copy(defaults);
    }

    public boolean isAbsent() {
        return false;
    }

    public static Cell empty() {
        return EMPTY;
    }

    public static Resource<Cell> pooled() {
        Thread current = Thread.currentThread();
        if (current instanceof ContextualThread) {
            ContextualThread contextual = (ContextualThread)((Object)current);
            return contextual.getContext().cell;
        }
        Resource<Cell> item = POOL.get();
        item.get().reset();
        return item;
    }

    public static interface ContextVisitor<C> {
        public void visit(Cell var1, int var2, int var3, C var4);
    }

    public static interface Visitor {
        public void visit(Cell var1, int var2, int var3);
    }
}

