/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.serialization.serializer;

import com.terraforged.core.serialization.serializer.Writer;

public abstract class AbstractWriter<T, S extends AbstractWriter<T, ?>>
implements Writer {
    private final Context<T> root = new Context(null);
    private String name = "";
    private Context<T> context = this.root;

    public T getRoot() {
        return (T)((Context)this.root).value;
    }

    public S name(String name) {
        this.name = name;
        return this.self();
    }

    public S beginObject() {
        this.begin(this.createObject());
        return this.self();
    }

    public S endObject() {
        this.context = ((Context)this.context).parent;
        return this.self();
    }

    public S beginArray() {
        this.begin(this.createArray());
        return this.self();
    }

    public S endArray() {
        this.context = ((Context)this.context).parent;
        return this.self();
    }

    public S value(String value) {
        this.append(this.create(value));
        return this.self();
    }

    public S value(float value) {
        this.append(this.create(value));
        return this.self();
    }

    public S value(int value) {
        this.append(this.create(value));
        return this.self();
    }

    private void begin(T value) {
        if (((Context)this.root).value == null) {
            ((Context)this.root).value = value;
            ((Context)this.context).value = value;
        } else {
            this.append(value);
            this.context = new Context(this.context);
            ((Context)this.context).value = value;
        }
    }

    private void append(T value) {
        if (this.isObject(((Context)this.context).value)) {
            this.add(((Context)this.context).value, this.name, value);
        } else if (this.isArray(((Context)this.context).value)) {
            this.add(((Context)this.context).value, value);
        }
    }

    protected abstract S self();

    protected abstract boolean isObject(T var1);

    protected abstract boolean isArray(T var1);

    protected abstract void add(T var1, String var2, T var3);

    protected abstract void add(T var1, T var2);

    protected abstract T createObject();

    protected abstract T createArray();

    protected abstract T create(String var1);

    protected abstract T create(int var1);

    protected abstract T create(float var1);

    private static class Context<T> {
        private final Context<T> parent;
        private T value;

        private Context(Context<T> root) {
            this.parent = root;
        }
    }
}

