/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm;

import com.terraforged.fm.FeatureDecorator;
import com.terraforged.fm.biome.BiomeFeatures;
import com.terraforged.fm.data.DataManager;
import com.terraforged.fm.modifier.FeatureModifierLoader;
import com.terraforged.fm.modifier.FeatureModifiers;
import com.terraforged.fm.modifier.ModifierSet;
import com.terraforged.fm.template.TemplateManager;
import com.terraforged.fm.transformer.InjectionPosition;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FeatureManager
implements FeatureDecorator {
    public static final Logger LOG = LogManager.getLogger((String)"FeatureManager");
    public static final Marker INIT = MarkerManager.getMarker((String)"INIT");
    private final Map<Biome, BiomeFeatures> biomes;

    public FeatureManager(Map<Biome, BiomeFeatures> biomes) {
        this.biomes = biomes;
    }

    @Override
    public FeatureManager getFeatureManager() {
        return this;
    }

    public BiomeFeatures getFeatures(Biome biome) {
        return this.biomes.getOrDefault(biome, BiomeFeatures.NONE);
    }

    public static DataManager data(File dir) {
        return DataManager.of(dir);
    }

    public static FeatureModifiers modifiers(DataManager data, boolean load) {
        if (load) {
            return FeatureModifierLoader.load(data);
        }
        return new FeatureModifiers();
    }

    public static void initData(DataManager manager) {
        TemplateManager.getInstance().load(manager);
    }

    public static void clearData() {
        TemplateManager.getInstance().clear();
    }

    public static FeatureManager create(FeatureModifiers modifiers) {
        LOG.debug(INIT, "Initializing FeatureManager");
        int predicates = modifiers.getPredicates().size();
        int replacers = modifiers.getReplacers().size();
        int injectors = modifiers.getInjectors().size();
        int transformers = modifiers.getTransformers().size();
        LOG.debug(INIT, " Predicates: {}, Replacers: {}, Injectors: {}, Transformers: {}", (Object)predicates, (Object)replacers, (Object)injectors, (Object)transformers);
        modifiers.sort();
        LOG.debug(INIT, " Compiling biome feature lists");
        HashMap<Biome, BiomeFeatures> biomes = new HashMap<Biome, BiomeFeatures>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            BiomeFeatures features = FeatureManager.compute(biome, modifiers);
            biomes.put(biome, features);
        }
        LOG.debug(INIT, " Initialization complete");
        return new FeatureManager(biomes);
    }

    private static BiomeFeatures compute(Biome biome, FeatureModifiers modifiers) {
        BiomeFeatures.Builder builder = BiomeFeatures.builder();
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            builder.add(stage, modifiers.getAppenders(stage, biome, InjectionPosition.HEAD));
            for (ConfiguredFeature feature : biome.func_203607_a(stage)) {
                ModifierSet modifierSet = modifiers.getFeature(stage, biome, feature);
                builder.add(stage, modifierSet.before);
                builder.add(stage, modifierSet.feature);
                builder.add(stage, modifierSet.after);
            }
            builder.add(stage, modifiers.getAppenders(stage, biome, InjectionPosition.TAIL));
        }
        return builder.build();
    }
}

