/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template;

import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.data.DataManager;
import com.terraforged.fm.template.TemplateLoader;
import com.terraforged.fm.template.feature.TemplateFeature;
import com.terraforged.fm.template.feature.TemplateFeatureConfig;
import com.terraforged.fm.template.type.FeatureTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TemplateManager {
    private static final Marker marker = MarkerManager.getMarker((String)"TEMPLATES");
    private static final TemplateManager instance = new TemplateManager();
    private final Map<ResourceLocation, TemplateFeatureConfig> templates = new HashMap<ResourceLocation, TemplateFeatureConfig>();

    public synchronized TemplateFeatureConfig getTemplateConfig(ResourceLocation name) {
        return this.templates.getOrDefault(name, TemplateFeatureConfig.NONE);
    }

    public synchronized void load(DataManager dataManager) {
        this.clear();
        FeatureTypes.clearFeatures();
        TemplateLoader loader = new TemplateLoader(dataManager);
        dataManager.forEachJson("templates", (location, data) -> {
            if (data.isJsonObject()) {
                TemplateFeatureConfig instance = TemplateFeatureConfig.parse(loader, data.getAsJsonObject());
                this.templates.put(instance.name, instance);
                FeatureManager.LOG.debug(marker, " Loaded template config: {}, size:{}", (Object)location, (Object)instance.templates.size());
            } else {
                FeatureManager.LOG.error(marker, " Failed to load template config: {}", (Object)location);
            }
        });
    }

    public synchronized void clear() {
        this.templates.clear();
    }

    public static TemplateManager getInstance() {
        return instance;
    }

    public static void register(RegistryEvent.Register<Feature<?>> event) {
        String namespace = ModLoadingContext.get().getActiveNamespace();
        event.getRegistry().register((IForgeRegistryEntry)new TemplateFeature(namespace));
    }
}

