/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public interface FeatureVisitor {
    public void visit(Feature<?> var1, IFeatureConfig var2);

    public void visit(Placement<?> var1, IPlacementConfig var2);

    default public void visitConfigured(ConfiguredFeature<?, ?> feature) {
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            this.visitDecorated((DecoratedFeatureConfig)feature.field_222738_b);
            return;
        }
        if (feature.field_222738_b instanceof SingleRandomFeature) {
            this.visitSingle((SingleRandomFeature)feature.field_222738_b);
            return;
        }
        if (feature.field_222738_b instanceof TwoFeatureChoiceConfig) {
            this.visitTwoChoice((TwoFeatureChoiceConfig)feature.field_222738_b);
            return;
        }
        if (feature.field_222738_b instanceof MultipleRandomFeatureConfig) {
            this.visitMulti((MultipleRandomFeatureConfig)feature.field_222738_b);
            return;
        }
        if (feature.field_222738_b instanceof MultipleWithChanceRandomFeatureConfig) {
            this.visitMultiChance((MultipleWithChanceRandomFeatureConfig)feature.field_222738_b);
            return;
        }
        this.visit(feature.field_222737_a, feature.field_222738_b);
    }

    default public void visitDecorated(DecoratedFeatureConfig config) {
        this.visitConfigured(config.field_214689_a);
        this.visit(config.field_214690_b.field_215096_a, config.field_214690_b.field_215097_b);
    }

    default public void visitSingle(SingleRandomFeature config) {
        for (ConfiguredFeature feature : config.field_204628_a) {
            this.visitConfigured(feature);
        }
    }

    default public void visitTwoChoice(TwoFeatureChoiceConfig config) {
        this.visitConfigured(config.field_227285_a_);
        this.visitConfigured(config.field_227286_b_);
    }

    default public void visitMulti(MultipleRandomFeatureConfig config) {
        for (ConfiguredRandomFeatureList feature : config.field_202449_a) {
            this.visitConfigured(feature.field_214842_a);
        }
    }

    default public void visitMultiChance(MultipleWithChanceRandomFeatureConfig config) {
        for (ConfiguredFeature feature : config.field_202454_a) {
            this.visitConfigured(feature);
        }
    }

    public static Predicate<ConfiguredFeature<?, ?>> featureFilter(Predicate<Feature<?>> predicate) {
        return feature -> {
            AtomicBoolean result = new AtomicBoolean();
            FeatureVisitor.feature((Feature<?> f) -> {
                if (predicate.test((Feature<?>)f)) {
                    result.set(true);
                }
            }).visitConfigured((ConfiguredFeature<?, ?>)feature);
            return result.get();
        };
    }

    public static FeatureVisitor feature(Consumer<Feature<?>> consumer) {
        return FeatureVisitor.create((f, c) -> consumer.accept((Feature<?>)f), (d, c) -> {});
    }

    public static FeatureVisitor featureConfig(Consumer<IFeatureConfig> consumer) {
        return FeatureVisitor.create((f, c) -> consumer.accept((IFeatureConfig)c), (d, c) -> {});
    }

    public static <T extends Feature<?>> FeatureVisitor feature(Class<T> type, Consumer<T> consumer) {
        return FeatureVisitor.feature(FeatureVisitor.consumerOf(type::isInstance, type::cast, consumer));
    }

    public static <T extends IFeatureConfig> FeatureVisitor featureConfig(Class<T> type, Consumer<T> consumer) {
        return FeatureVisitor.featureConfig(FeatureVisitor.consumerOf(type::isInstance, type::cast, consumer));
    }

    public static FeatureVisitor feature(BiConsumer<Feature<?>, IFeatureConfig> consumer) {
        return FeatureVisitor.create(consumer, (d, c) -> {});
    }

    public static FeatureVisitor decorator(Consumer<Placement<?>> consumer) {
        return FeatureVisitor.create((f, c) -> {}, (d, c) -> consumer.accept((Placement<?>)d));
    }

    public static FeatureVisitor decoratorConfig(Consumer<IPlacementConfig> consumer) {
        return FeatureVisitor.create((f, c) -> {}, (d, c) -> consumer.accept((IPlacementConfig)c));
    }

    public static <T extends Placement<?>> FeatureVisitor decorator(Class<T> type, Consumer<T> consumer) {
        return FeatureVisitor.decorator(FeatureVisitor.consumerOf(type::isInstance, type::cast, consumer));
    }

    public static <T extends IPlacementConfig> FeatureVisitor decoratorConfig(Class<T> type, Consumer<T> consumer) {
        return FeatureVisitor.decoratorConfig(FeatureVisitor.consumerOf(type::isInstance, type::cast, consumer));
    }

    public static FeatureVisitor decorator(BiConsumer<Placement<?>, IPlacementConfig> consumer) {
        return FeatureVisitor.create((f, c) -> {}, consumer);
    }

    public static <In, Out> Consumer<In> consumerOf(Predicate<In> predicate, Function<In, Out> mapper, Consumer<Out> consumer) {
        return in -> {
            if (predicate.test(in)) {
                Object out = mapper.apply(in);
                consumer.accept(out);
            }
        };
    }

    public static FeatureVisitor create(final BiConsumer<Feature<?>, IFeatureConfig> features, final BiConsumer<Placement<?>, IPlacementConfig> decorators) {
        return new FeatureVisitor(){

            @Override
            public void visit(Feature<?> feature, IFeatureConfig config) {
                features.accept(feature, config);
            }

            @Override
            public void visit(Placement<?> decorator, IPlacementConfig config) {
                decorators.accept(decorator, config);
            }
        };
    }

    public static interface DecoratorV
    extends FeatureVisitor {
        @Override
        default public void visit(Feature<?> feature, IFeatureConfig config) {
        }
    }

    public static interface FeatureV
    extends FeatureVisitor {
        @Override
        default public void visit(Placement<?> decorator, IPlacementConfig config) {
        }
    }
}

