/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.BiomeMapBuilder;
import com.terraforged.mod.biome.map.defaults.DefaultBiomes;
import com.terraforged.mod.biome.map.set.BiomeSet;
import com.terraforged.mod.biome.map.set.BiomeTypeSet;
import com.terraforged.mod.biome.map.set.RiverSet;
import com.terraforged.mod.biome.map.set.TemperatureSet;
import com.terraforged.mod.biome.map.set.WetlandSet;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.biome.BiomeType;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.TerrainType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class SimpleBiomeMap
implements BiomeMap {
    private final BiomeSet deepOcean;
    private final BiomeSet shallowOcean;
    private final BiomeSet beach;
    private final BiomeSet coast;
    private final BiomeSet river;
    private final BiomeSet lake;
    private final BiomeSet wetland;
    private final BiomeTypeSet land;
    private final BiomeSet mountains;
    private final BiomeSet[] terrainBiomes;

    public SimpleBiomeMap(BiomeMapBuilder builder) {
        this.deepOcean = new TemperatureSet(builder.deepOceans, DefaultBiomes::defaultDeepOcean);
        this.shallowOcean = new TemperatureSet(builder.oceans, DefaultBiomes::defaultOcean);
        this.beach = new TemperatureSet(builder.beaches, DefaultBiomes::defaultBeach);
        this.coast = new TemperatureSet(builder.coasts, DefaultBiomes::defaultBiome);
        this.river = new RiverSet(builder.rivers, DefaultBiomes::defaultRiver, this);
        this.lake = new TemperatureSet(builder.lakes, DefaultBiomes::defaultLake);
        this.wetland = new WetlandSet(builder.wetlands, this);
        this.mountains = new TemperatureSet(builder.mountains, DefaultBiomes::defaultMountain);
        this.land = new BiomeTypeSet(builder.map, DefaultBiomes::defaultBiome);
        this.terrainBiomes = new BiomeSet[TerrainType.values().length];
        this.terrainBiomes[TerrainType.SHALLOW_OCEAN.ordinal()] = this.shallowOcean;
        this.terrainBiomes[TerrainType.DEEP_OCEAN.ordinal()] = this.deepOcean;
        this.terrainBiomes[TerrainType.WETLAND.ordinal()] = this.wetland;
        this.terrainBiomes[TerrainType.RIVER.ordinal()] = this.river;
        this.terrainBiomes[TerrainType.LAKE.ordinal()] = this.lake;
        for (TerrainType type : TerrainType.values()) {
            if (this.terrainBiomes[type.ordinal()] != null) continue;
            this.terrainBiomes[type.ordinal()] = this.land;
        }
    }

    @Override
    public Biome provideBiome(Cell cell, Levels levels) {
        TerrainType type = cell.terrain.getType();
        if (type.isSubmerged() && cell.value > levels.water) {
            return this.land.getBiome(cell);
        }
        return this.terrainBiomes[cell.terrain.getType().ordinal()].getBiome(cell);
    }

    @Override
    public Biome getDeepOcean(Cell cell) {
        return this.deepOcean.getBiome(cell);
    }

    @Override
    public Biome getShallowOcean(Cell cell) {
        return this.shallowOcean.getBiome(cell);
    }

    @Override
    public Biome getBeach(Cell cell) {
        return this.beach.getBiome(cell);
    }

    @Override
    public Biome getCoast(Cell cell) {
        Biome[] coastal;
        Biome[] inland = this.land.getSet(cell);
        int maxIndex = inland.length + (coastal = this.coast.getSet(cell)).length - 1;
        int index = NoiseUtil.round((float)maxIndex * cell.biomeIdentity);
        if (index >= inland.length && (index -= inland.length) < coastal.length) {
            return coastal[index];
        }
        return DefaultBiomes.NONE;
    }

    @Override
    public Biome getRiver(Cell cell) {
        return this.river.getBiome(cell);
    }

    @Override
    public Biome getLake(Cell cell) {
        return this.lake.getBiome(cell);
    }

    @Override
    public Biome getWetland(Cell cell) {
        return this.wetland.getBiome(cell);
    }

    @Override
    public Biome getMountain(Cell cell) {
        return this.mountains.getBiome(cell);
    }

    @Override
    public Biome getLand(Cell cell) {
        return this.land.getBiome(cell);
    }

    @Override
    public BiomeTypeSet getLandSet() {
        return this.land;
    }

    @Override
    public List<Biome> getAllBiomes(BiomeType type) {
        if (type == BiomeType.ALPINE) {
            return Collections.emptyList();
        }
        int size = this.land.getSize(type.ordinal());
        if (size == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.land.getSet(type.ordinal()));
    }

    @Override
    public JsonElement toJson() {
        JsonObject root = new JsonObject();
        root.add("DEEP_OCEAN", this.deepOcean.toJson());
        root.add("SHALLOW_OCEAN", this.shallowOcean.toJson());
        root.add("BEACH", this.beach.toJson());
        root.add("COAST", this.coast.toJson());
        root.add("RIVER", this.river.toJson());
        root.add("LAKE", this.lake.toJson());
        root.add("WETLAND", this.wetland.toJson());
        root.add("LAND", this.landToJson());
        return root;
    }

    private JsonElement landToJson() {
        JsonObject root = this.land.toJson().getAsJsonObject();
        root.add(BiomeType.ALPINE.name(), this.mountains.toJson());
        return root;
    }
}

