/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.api.biome.modifier.BiomeModifier;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.defaults.DefaultBiomes;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.world.terrain.Terrains;
import net.minecraft.world.biome.Biome;

public class CoastModifier
implements BiomeModifier {
    private final float height;
    private final Terrains terrain;
    private final BiomeMap biomeMap;

    public CoastModifier(BiomeMap biomeMap, TerraContext context) {
        this.terrain = context.terrain;
        this.biomeMap = biomeMap;
        this.height = context.levels.water(8);
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public boolean test(Biome biome, Cell cell) {
        return cell.terrain.isCoast();
    }

    @Override
    public Biome modify(Biome in, Cell cell, int x, int z) {
        Biome coast;
        if (cell.terrain.isCoast() && (coast = this.biomeMap.getCoast(cell)) != DefaultBiomes.NONE) {
            return coast;
        }
        return in;
    }
}

