/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.spawn;

import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import com.terraforged.mod.biome.spawn.SpawnSearch;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.continent.SpawnType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnHandler {
    @SubscribeEvent
    public static void createSpawn(WorldEvent.CreateSpawnPosition event) {
        ServerWorld world;
        ChunkGenerator generator;
        if (event.getWorld() instanceof ServerWorld && (generator = (world = (ServerWorld)event.getWorld()).func_72863_F().func_201711_g()).func_202090_b() instanceof TerraBiomeProvider) {
            Log.info("Searching for world spawn position", new Object[0]);
            TerraBiomeProvider provider = (TerraBiomeProvider)generator.func_202090_b();
            BlockPos center = SpawnHandler.getSearchCenter(provider);
            SpawnSearch search = new SpawnSearch(center, provider);
            BlockPos spawn = SpawnHandler.getSurface(generator, search.get());
            Log.info("Setting world spawn: {}", spawn);
            event.setCanceled(true);
            event.getWorld().func_72912_H().func_176143_a(spawn);
            if (event.getSettings().func_77167_c()) {
                Log.info("Generating bonus chest", new Object[0]);
                SpawnHandler.createBonusChest(world, spawn);
            }
        }
    }

    private static BlockPos getSearchCenter(TerraBiomeProvider provider) {
        SpawnType spawnType = provider.getContext().terraSettings.world.properties.spawnType;
        if (spawnType == SpawnType.WORLD_ORIGIN) {
            return BlockPos.field_177992_a;
        }
        MutableVeci pos = new MutableVeci();
        provider.getContext().heightmap.getContinent().getNearestCenter(0.0f, 0.0f, pos);
        return new BlockPos(pos.x, 0, pos.z);
    }

    private static BlockPos getSurface(ChunkGenerator<?> generator, BlockPos pos) {
        int surface = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        return new BlockPos(pos.func_177958_n(), surface, pos.func_177952_p());
    }

    private static void createBonusChest(ServerWorld world, BlockPos pos) {
        ConfiguredFeature chest = Feature.field_214487_aO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        chest.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), world.field_73012_v, pos);
    }
}

