/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.api.biome.surface.MaskedSurface;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.core.Seed;
import com.terraforged.core.util.Variance;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.geology.DepthBuffer;
import com.terraforged.world.geology.Strata;
import com.terraforged.world.geology.Stratum;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;

public class BriceSurface
implements MaskedSurface,
Stratum.Visitor<BlockState, SurfaceContext> {
    private final Module module;
    private final Strata<BlockState> stackStrata;

    public BriceSurface(Seed seed) {
        Random random = new Random(seed.next());
        Variance variance = Variance.of(0.1, 0.2);
        this.module = Source.ridge(123, 60, 4).clamp(0.8, 0.95).map(0.0, 1.0).terrace(1.0, 0.25, 4, 1.0).mult(Source.perlin(1234, 4, 1).alpha(0.05));
        this.stackStrata = Strata.builder(seed.next(), Source.build(seed.next(), 30, 3)).add(Blocks.field_196778_fp.func_176223_P(), variance.next(random)).add(Blocks.field_150405_ch.func_176223_P(), variance.next(random)).add(Blocks.field_196783_fs.func_176223_P(), variance.next(random)).add(Blocks.field_196777_fo.func_176223_P(), variance.next(random)).add(Blocks.field_196719_fA.func_176223_P(), variance.next(random)).add(Blocks.field_196721_fC.func_176223_P(), variance.next(random)).build();
    }

    @Override
    public void buildSurface(int x, int z, int height, float mask, SurfaceContext ctx) {
        float strength = 1.0f - ctx.cell.gradient;
        float value = this.module.getValue(x, z) * mask * strength;
        int top = (int)(value * 30.0f);
        if (top == 0) {
            return;
        }
        this.stackStrata.downwards(x, top, z, (DepthBuffer)ctx.depthBuffer.get(), ctx, this);
    }

    @Override
    public boolean visit(int y, BlockState state, SurfaceContext ctx) {
        if (y <= 0) {
            return false;
        }
        ctx.pos.func_185336_p(y);
        ctx.chunk.func_177436_a((BlockPos)ctx.pos, state, false);
        return true;
    }
}

