/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.column;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.material.state.States;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.material.Materials;
import com.terraforged.world.terrain.Terrains;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class ErosionDecorator
implements ColumnDecorator {
    private static final int ROCK_VAR = 30;
    private static final int ROCK_MIN = 140;
    private static final int DIRT_VAR = 40;
    private static final int DIRT_MIN = 95;
    public static final float ROCK_STEEPNESS = 0.65f;
    private static final float DIRT_STEEPNESS = 0.475f;
    private static final float SCREE_STEEPNESS = 0.4f;
    public static final float HEIGHT_MODIFIER = 0.023529412f;
    public static final float SLOPE_MODIFIER = 0.011764706f;
    private static final float SEDIMENT_MODIFIER = 256.0f;
    private static final float SEDIMENT_NOISE = 0.011764706f;
    private static final float SCREE_VALUE = 0.55f;
    private final int seed1;
    private final int seed2;
    private final int seed3;
    private final float minY;
    private final Terrains terrain;
    private final Materials materials;

    public ErosionDecorator(TerraContext context) {
        this.terrain = context.terrain;
        this.seed1 = context.seed.next();
        this.seed2 = context.seed.next();
        this.seed3 = context.seed.next();
        this.minY = context.levels.water;
        this.materials = context.materials;
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        if (context.cell.value < this.minY || context.cell.terrain.isRiver() || context.cell.terrain.isWetland()) {
            return;
        }
        if (context.cell.terrain == this.terrain.volcanoPipe) {
            return;
        }
        y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        ISurfaceBuilderConfig config = context.biome.func_203944_q();
        BlockState top = config.func_204108_a();
        BlockState middle = config.func_204109_b();
        if (this.materials.isErodible(top.func_177230_c())) {
            BlockState material = this.getMaterial(x, z, context, top, middle);
            if (material != top) {
                if (this.materials.isStone(material.func_177230_c())) {
                    this.erodeRock(context, chunk, x, y, z);
                    return;
                }
                this.fillDownSolid(context, chunk, x, z, y, y - 4, material);
            }
            this.placeScree(chunk, context, x, y, z);
        }
    }

    protected void erodeRock(DecoratorContext context, IChunk chunk, int dx, int y, int dz) {
        int dy;
        int depth = 32;
        BlockState material = (BlockState)States.GRAVEL.get();
        for (dy = 3; dy < 32; ++dy) {
            context.pos.func_181079_c(dx, y - dy, dz);
            BlockState state = chunk.func_180495_p((BlockPos)context.pos);
            if (!this.materials.isStone(state.func_177230_c())) continue;
            material = state;
            depth = dy + 1;
            break;
        }
        for (dy = 0; dy < depth; ++dy) {
            ColumnDecorator.replaceSolid(chunk, (BlockPos)context.pos.func_181079_c(dx, y - dy, dz), material);
        }
    }

    protected void placeScree(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        float steepness = context.cell.gradient + context.climate.getRand().getValue(x, z, this.seed2) * 0.011764706f;
        if (steepness < 0.4f) {
            return;
        }
        float sediment = context.cell.sediment * 256.0f;
        float noise = context.climate.getRand().getValue(x, z, this.seed3) * 0.011764706f;
        if (sediment + noise > 0.55f) {
            this.fillDownSolid(context, chunk, x, z, y, y - 2, (BlockState)States.GRAVEL.get());
        }
    }

    public boolean erodeRock(float x, float z, float steepness, float height) {
        return steepness > 0.65f || height > ColumnDecorator.getNoise(x, z, this.seed1, 30, 140);
    }

    public boolean erodeDirt(float x, float z, float steepness, float height) {
        return steepness > 0.475f && height > ColumnDecorator.getNoise(x, z, this.seed2, 40, 95);
    }

    private BlockState getMaterial(float x, float z, DecoratorContext context, BlockState top, BlockState middle) {
        float height = context.cell.value + context.climate.getRand().getValue(x, z, this.seed1) * 0.023529412f;
        float steepness = context.cell.gradient + context.climate.getRand().getValue(x, z, this.seed2) * 0.011764706f;
        if (steepness > 0.65f || height > ColumnDecorator.getNoise(x, z, this.seed1, 30, 140)) {
            return ErosionDecorator.rock(middle);
        }
        if (steepness > 0.475f && height > ColumnDecorator.getNoise(x, z, this.seed2, 40, 95)) {
            return ErosionDecorator.ground(top);
        }
        return top;
    }

    private static BlockState rock(BlockState state) {
        if (state.func_185904_a() == Material.field_151576_e) {
            return state;
        }
        return (BlockState)States.STONE.get();
    }

    private static BlockState ground(BlockState state) {
        if (state.func_185904_a() == Material.field_151577_b) {
            return (BlockState)States.DIRT.get();
        }
        if (state.func_185904_a() == Material.field_151576_e) {
            return (BlockState)States.GRAVEL.get();
        }
        if (state.func_185904_a() == Material.field_151578_c) {
            return state;
        }
        if (state.func_185904_a() == Material.field_151595_p) {
            if (state.func_177230_c() == Blocks.field_150354_m) {
                return (BlockState)States.SMOOTH_SANDSTONE.get();
            }
            if (state.func_177230_c() == Blocks.field_196611_F) {
                return (BlockState)States.SMOOTH_RED_SANDSTONE.get();
            }
        }
        return (BlockState)States.COARSE_DIRT.get();
    }
}

