/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.api.biome.surface.ChunkSurfaceBuffer;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.util.FastChunk;
import com.terraforged.mod.chunk.util.TerraContainer;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;

public class SurfaceGenerator
implements Generator.Surfaces {
    private final TerraChunkGenerator generator;
    private final INoiseGenerator surfaceNoise;

    public SurfaceGenerator(TerraChunkGenerator generator) {
        this.generator = generator;
        this.surfaceNoise = new PerlinNoiseGenerator(new SharedSeedRandom(generator.func_202089_c()), 3, 0);
    }

    @Override
    public final void generateSurface(WorldGenRegion world, IChunk chunk) {
        try (ChunkReader reader = this.generator.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);){
            TerraContainer container = TerraContainer.getOrCreate(chunk, reader, this.generator.getBiomeProvider());
            ChunkSurfaceBuffer buffer = new ChunkSurfaceBuffer(FastChunk.wrap(chunk));
            try (SurfaceContext context = this.generator.getContext().surface(buffer, this.generator.func_201496_a_());){
                reader.iterate(context, (cell, dx, dz, ctx) -> {
                    int px = ctx.blockX + dx;
                    int pz = ctx.blockZ + dz;
                    int top = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, dx, dz);
                    ctx.buffer.setSurfaceLevel(top);
                    ctx.cell = cell;
                    ctx.biome = container.getBiome(dx, dz);
                    ctx.noise = this.getSurfaceNoise(px, pz) * 15.0;
                    this.generator.getSurfaceManager().getSurface((SurfaceContext)ctx).buildSurface(px, pz, top, (SurfaceContext)ctx);
                    int py = ctx.levels.scale(cell.value);
                    for (ColumnDecorator processor : this.generator.getBaseDecorators()) {
                        processor.decorate(ctx.buffer, (SurfaceContext)ctx, px, py, pz);
                    }
                });
                FastChunk.updateWGHeightmaps(chunk, context.pos);
            }
        }
    }

    private double getSurfaceNoise(int x, int z) {
        double scale = 0.0625;
        double noiseX = (double)x * scale;
        double noiseZ = (double)z * scale;
        double unusedValue1 = scale;
        double unusedValue2 = (double)(x & 0xF) * scale;
        return this.surfaceNoise.func_215460_a(noiseX, noiseZ, unusedValue1, unusedValue2);
    }
}

