/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings;

import com.terraforged.core.serialization.annotation.Comment;
import com.terraforged.core.serialization.annotation.Limit;
import com.terraforged.core.serialization.annotation.Range;
import com.terraforged.core.serialization.annotation.Serializable;
import net.minecraft.world.gen.OverworldGenSettings;

@Serializable
public class StructureSettings {
    private static final StructureDefaults defaults = new StructureDefaults();
    public Structure villages;
    public Structure mansions;
    public Structure strongholds;
    public Structure shipwrecks;
    public Structure oceanRuins;
    public Structure oceanMonuments;
    public Structure otherStructures;

    public StructureSettings() {
        this.villages = new Structure(StructureSettings.defaults.village_dist, StructureSettings.defaults.village_sep);
        this.mansions = new Structure(StructureSettings.defaults.mansionDist, StructureSettings.defaults.mansionSep);
        this.strongholds = new Structure(StructureSettings.defaults.strongholdDist, StructureSettings.defaults.strongholdSep);
        this.shipwrecks = new Structure(StructureSettings.defaults.shipWreckDist, StructureSettings.defaults.shipWreckSep);
        this.oceanRuins = new Structure(StructureSettings.defaults.oceanRuinDist, StructureSettings.defaults.oceanRuinSep);
        this.oceanMonuments = new Structure(StructureSettings.defaults.oceanMonumentDist, StructureSettings.defaults.oceanMonumentSep);
        this.otherStructures = new Structure(StructureSettings.defaults.otherStructureDist, StructureSettings.defaults.otherStructureSep);
    }

    private static class StructureDefaults {
        public final int village_dist;
        public final int village_sep;
        public final int mansionDist;
        public final int mansionSep;
        public final int strongholdDist;
        public final int strongholdSep;
        public final int shipWreckDist;
        public final int shipWreckSep;
        public final int oceanRuinDist;
        public final int oceanRuinSep;
        public final int oceanMonumentDist;
        public final int oceanMonumentSep;
        public final int otherStructureDist;
        public final int otherStructureSep;

        public StructureDefaults() {
            OverworldGenSettings defaults = new OverworldGenSettings();
            this.village_dist = (int)((double)defaults.func_202173_a() * 1.5);
            this.village_sep = (int)((double)defaults.func_211729_b() * 1.5);
            this.shipWreckDist = (int)((double)defaults.func_204748_h() * 2.0);
            this.shipWreckSep = (int)((double)defaults.func_211730_k() * 2.0);
            this.oceanRuinDist = (int)((double)defaults.func_204026_h() * 2.0);
            this.oceanRuinSep = (int)((double)defaults.func_211727_m() * 2.0);
            this.oceanMonumentDist = (int)((double)defaults.func_204026_h() * 1.5);
            this.oceanMonumentSep = (int)((double)defaults.func_211727_m() * 1.5);
            this.mansionDist = defaults.func_202179_i();
            this.mansionSep = defaults.func_211726_q();
            this.strongholdDist = defaults.func_211726_q();
            this.strongholdSep = defaults.func_211726_q();
            this.otherStructureDist = defaults.func_202177_g();
            this.otherStructureSep = defaults.func_211731_i();
        }
    }

    @Serializable
    public static class Structure {
        @Range(min=5.0f, max=1000.0f)
        @Limit(lower="separation", pad=2.0f)
        @Comment(value={"The maximum distance in chunks between attempts to spawn a structure", "Values higher than 200 may break the game"})
        public int distance;
        @Range(min=4.0f, max=1000.0f)
        @Limit(upper="distance", pad=2.0f)
        @Comment(value={"The minimum distance in chunks between structure spawns", "Values higher than 200 may break the game"})
        public int separation;

        public Structure() {
        }

        public Structure(int distance, int separation) {
            this.distance = distance;
            this.separation = separation;
        }
    }
}

