/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.preview2;

import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.OverlayScreen;
import com.terraforged.mod.client.gui.element.TerraButton;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.UpdatablePage;
import com.terraforged.mod.client.gui.preview2.Preview;
import com.terraforged.mod.client.gui.preview2.PreviewSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;

public class PreviewPage
extends UpdatablePage {
    private final Preview preview;
    private final CompoundNBT settings;
    private final TerraSettings genSettings = new TerraSettings();

    public PreviewPage(TerraSettings settings, int seed) {
        this.preview = new Preview(settings, seed);
        this.settings = NBTHelper.serialize("preview", new PreviewSettings());
    }

    public int getSeed() {
        return this.preview.getSeed();
    }

    @Override
    public void close() {
        this.preview.close();
    }

    @Override
    public void apply(Consumer<TerraSettings> consumer) {
        consumer.accept(this.genSettings);
        this.update();
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column right = this.getColumn(1);
        this.preview.x = 0;
        this.preview.y = 0;
        this.preview.setWidth(com.terraforged.mod.client.gui.preview.Preview.SIZE);
        this.preview.setHeight(com.terraforged.mod.client.gui.preview.Preview.SIZE);
        this.addElements(right.left, right.top, right, this.settings, right.scrollPane::addButton, this::update);
        right.scrollPane.addButton((Widget)new TerraButton("New Seed"){

            public void onPress() {
                PreviewPage.this.preview.nextSeed();
                PreviewPage.this.update();
            }
        });
        right.scrollPane.addButton(this.preview);
        TerraButton spacer = PreviewPage.createSpacer();
        for (int i = 0; i < 7; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
    }

    @Override
    public void update() {
        PreviewSettings settings = new PreviewSettings();
        NBTHelper.deserialize(this.settings, settings);
        this.preview.update(settings, this.genSettings);
    }

    private static TerraButton createSpacer() {
        return new TerraButton(""){

            public void render(int x, int y, float tick) {
            }
        };
    }
}

