/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.feature;

import com.terraforged.fm.template.BlockUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FreezeLayer
extends Feature<NoFeatureConfig> {
    public static final FreezeLayer INSTANCE = new FreezeLayer();

    public FreezeLayer() {
        super(NoFeatureConfig::func_214639_a);
        this.setRegistryName("terraforged", "freeze_top_layer");
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable pos1 = new BlockPos.Mutable();
        BlockPos.Mutable pos2 = new BlockPos.Mutable();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = pos.func_177958_n() + dx;
                int z = pos.func_177952_p() + dz;
                int y1 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
                int y2 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
                pos1.func_181079_c(x, y1, z);
                pos2.func_189533_g((Vec3i)pos1).func_189534_c(Direction.DOWN, 1);
                Biome biome = world.func_226691_t_((BlockPos)pos1);
                boolean freezesHere = this.freeze(world, biome, pos1, (BlockPos)pos2, false, false);
                if (y1 == y2) continue;
                pos1.func_181079_c(x, y2, z);
                pos2.func_189533_g((Vec3i)pos1).func_189534_c(Direction.DOWN, 1);
                this.freeze(world, biome, pos1, (BlockPos)pos2, freezesHere, true);
            }
        }
        return true;
    }

    private boolean freeze(IWorld world, Biome biome, BlockPos.Mutable top, BlockPos below, boolean force, boolean ground) {
        boolean hasFrozen = false;
        if (biome.func_201854_a((IWorldReader)world, below, false)) {
            world.func_180501_a(below, Blocks.field_150432_aD.func_176223_P(), 2);
            hasFrozen = true;
        }
        if (force || biome.func_201850_b((IWorldReader)world, (BlockPos)top)) {
            hasFrozen = true;
            BlockState stateUnder = world.func_180495_p(below);
            if (stateUnder.func_177230_c() == Blocks.field_150350_a) {
                return false;
            }
            if (ground) {
                if (BlockTags.field_200031_h.func_199685_a_((Object)stateUnder.func_177230_c())) {
                    return false;
                }
                top.func_189534_c(Direction.UP, 1);
                BlockState above = world.func_180495_p((BlockPos)top);
                if (BlockTags.field_200031_h.func_199685_a_((Object)above.func_177230_c()) || BlockTags.field_206952_E.func_199685_a_((Object)above.func_177230_c())) {
                    return false;
                }
                top.func_189534_c(Direction.DOWN, 1);
                if (this.setSnow(world, (BlockPos)top, below, stateUnder) && above.func_177230_c() != Blocks.field_150350_a) {
                    world.func_180501_a((BlockPos)top, Blocks.field_150350_a.func_176223_P(), 2);
                }
            } else {
                this.setSnow(world, (BlockPos)top, below, stateUnder);
            }
        }
        return hasFrozen;
    }

    private boolean setSnow(IWorld world, BlockPos pos1, BlockPos pos2, BlockState below) {
        if (BlockUtils.isSolid((IWorldReader)world, pos1)) {
            return false;
        }
        world.func_180501_a(pos1, Blocks.field_150433_aE.func_176223_P(), 2);
        if (below.func_196959_b((IProperty)SnowyDirtBlock.field_196382_a)) {
            world.func_180501_a(pos2, (BlockState)below.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }
}

