/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.domain;

import com.terraforged.cereal.spec.Context;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.cereal.value.DataObject;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.domain.Domain;

public class DomainWarp
implements Domain {
    private final Module x;
    private final Module y;
    private final Module distance;

    public DomainWarp(Module x, Module y, Module distance) {
        this.x = DomainWarp.map(x);
        this.y = DomainWarp.map(y);
        this.distance = distance;
    }

    @Override
    public String getSpecName() {
        return "DomainWarp";
    }

    @Override
    public float getOffsetX(float x, float y) {
        return this.x.getValue(x, y) * this.distance.getValue(x, y);
    }

    @Override
    public float getOffsetY(float x, float y) {
        return this.y.getValue(x, y) * this.distance.getValue(x, y);
    }

    private static Module map(Module in) {
        if (in.minValue() == -0.5f && in.maxValue() == 0.5f) {
            return in;
        }
        float range = in.maxValue() - in.minValue();
        if (range == 1.0f) {
            float bias = -0.5f - in.minValue();
            return in.bias(bias);
        }
        return in.map(-0.5, 0.5);
    }

    private static DomainWarp create(DataObject data, DataSpec<?> spec, Context context) {
        return new DomainWarp(spec.get("x", data, Module.class, context), spec.get("y", data, Module.class, context), spec.get("distance", data, Module.class, context));
    }

    public static DataSpec<? extends Domain> spec() {
        return DataSpec.builder("DomainWarp", DomainWarp.class, DomainWarp::create).addObj("x", Module.class, w -> w.x).addObj("y", Module.class, w -> w.y).addObj("distance", Module.class, w -> w.distance).build();
    }
}

