/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world;

import com.terraforged.core.filter.BeachDetect;
import com.terraforged.core.filter.Erosion;
import com.terraforged.core.filter.Filterable;
import com.terraforged.core.filter.Smoothing;
import com.terraforged.core.filter.Steepness;
import com.terraforged.core.settings.FilterSettings;
import com.terraforged.core.tile.Size;
import com.terraforged.core.tile.Tile;
import com.terraforged.world.GeneratorContext;
import java.util.function.IntFunction;

public class WorldFilters {
    private final Smoothing smoothing;
    private final Steepness steepness;
    private final BeachDetect beach;
    private final FilterSettings settings;
    private final IntFunction<Erosion> erosionFactory;
    private final Object lock = new Object();
    private Erosion erosion = null;

    public WorldFilters(GeneratorContext context) {
        context = context.copy();
        this.settings = context.settings.filters;
        this.beach = new BeachDetect(context);
        this.smoothing = new Smoothing(context.settings, context.levels);
        this.steepness = new Steepness(1, 10.0f, context.terrain, context.levels);
        this.erosionFactory = Erosion.factory(context);
    }

    public void apply(Tile tile, boolean optionalFilters) {
        Filterable map = tile.filterable();
        if (optionalFilters) {
            this.getErosion(map.getSize()).apply(map, tile.getRegionX(), tile.getRegionZ(), this.settings.erosion.iterations);
            this.smoothing.apply(map, tile.getRegionX(), tile.getRegionZ(), this.settings.smoothing.iterations);
        }
        this.steepness.apply(map, tile.getRegionX(), tile.getRegionZ(), 1);
        this.beach.apply(map, tile.getRegionX(), tile.getRegionZ(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Erosion getErosion(Size size) {
        Object object = this.lock;
        synchronized (object) {
            if (this.erosion == null || this.erosion.getSize() != size.total) {
                this.erosion = this.erosionFactory.apply(size.total);
            }
        }
        return this.erosion;
    }
}

