/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.continent.generator;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.settings.WorldSettings;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.n2d.domain.Domain;
import com.terraforged.n2d.func.DistanceFunc;
import com.terraforged.n2d.func.EdgeFunc;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.n2d.util.Vec2f;
import com.terraforged.world.continent.Continent;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.heightmap.ControlPoints;

public abstract class ContinentGenerator
implements Continent {
    protected final int seed;
    protected final float frequency;
    protected final int continentScale;
    private final DistanceFunc distanceFunc;
    private final ControlPoints controlPoints;
    private final float clampMin;
    private final float clampMax;
    private final float clampRange;
    protected final Domain warp;
    protected final Module shape;

    public ContinentGenerator(Seed seed, WorldSettings settings) {
        int tectonicScale = settings.continent.continentScale * 4;
        this.continentScale = settings.continent.continentScale / 2;
        this.seed = seed.next();
        this.distanceFunc = settings.continent.continentShape;
        this.controlPoints = new ControlPoints(settings.controlPoints);
        this.frequency = 1.0f / (float)tectonicScale;
        this.clampMin = 0.2f;
        this.clampMax = 1.0f;
        this.clampRange = this.clampMax - this.clampMin;
        this.warp = Domain.warp(Source.PERLIN, seed.next(), 20, 2, 20.0).warp(Domain.warp(Source.SIMPLEX, seed.next(), this.continentScale, 3, this.continentScale));
        this.shape = Source.simplex(seed.next(), settings.continent.continentScale * 2, 1).bias(0.65).clamp(0.0, 1.0);
    }

    @Override
    public float getValue(float x, float y) {
        Cell cell = new Cell();
        this.apply(cell, x, y);
        return cell.continentEdge;
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        float ox = this.warp.getOffsetX(x, y);
        float oz = this.warp.getOffsetY(x, y);
        float px = x + ox;
        float py = y + oz;
        int cellX = 0;
        int cellY = 0;
        int xr = NoiseUtil.round(px *= this.frequency);
        int yr = NoiseUtil.round(py *= this.frequency);
        Vec2f center = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xr, yr) & 0xFF];
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        float valueDistance = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int cx = xr + dx;
                int cy = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, cx, cy) & 0xFF];
                float vecX = (float)cx - px + vec.x;
                float vecY = (float)cy - py + vec.y;
                float distance = this.distanceFunc.apply(vecX, vecY);
                if (distance < valueDistance) {
                    valueDistance = distance;
                    cellX = cx;
                    cellY = cy;
                    center = vec;
                }
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        cell.continentIdentity = this.cellIdentity(this.seed, cellX, cellY);
        cell.continentEdge = this.cellEdgeValue(edgeDistance, edgeDistance2);
        cell.continentX = (int)(((float)cellX + center.x) / this.frequency);
        cell.continentZ = (int)(((float)cellY + center.y) / this.frequency);
        cell.continentEdge *= this.getShape(x, y, cell.continentEdge);
    }

    @Override
    public final float getEdgeNoise(float x, float y) {
        float ox = this.warp.getOffsetX(x, y);
        float oz = this.warp.getOffsetY(x, y);
        float px = x + ox;
        float py = y + oz;
        int xr = NoiseUtil.round(px *= this.frequency);
        int yr = NoiseUtil.round(py *= this.frequency);
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - px + vec.x;
                float vecY = (float)yi - py + vec.y;
                float distance = this.distanceFunc.apply(vecX, vecY);
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        float edgeValue = this.cellEdgeValue(edgeDistance, edgeDistance2);
        float shapeNoise = this.getShape(x, y, edgeValue);
        return edgeValue * shapeNoise;
    }

    @Override
    public void getNearestCenter(float x, float z, MutableVeci pos) {
        float ox = this.warp.getOffsetX(x, z);
        float oz = this.warp.getOffsetY(x, z);
        float px = x + ox;
        float py = z + oz;
        int cellX = 0;
        int cellY = 0;
        Vec2f center = null;
        int xr = NoiseUtil.round(px *= this.frequency);
        int yr = NoiseUtil.round(py *= this.frequency);
        float valueDistance = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - px + vec.x;
                float vecY = (float)yi - py + vec.y;
                float distance = this.distanceFunc.apply(vecX, vecY);
                if (!(distance < valueDistance) && (center != null || dx != 0 || dy != 0)) continue;
                valueDistance = distance;
                center = vec;
                cellX = xi;
                cellY = yi;
            }
        }
        pos.x = (int)(((float)cellX + center.x) / this.frequency);
        pos.z = (int)(((float)cellY + center.y) / this.frequency);
    }

    @Override
    public float getDistanceToOcean(int cx, int cz, float dx, float dz, MutableVeci pos) {
        float high = this.getDistanceToEdge(cx, cz, dx, dz, pos);
        float low = 0.0f;
        for (int i = 0; i < 50; ++i) {
            float mid = (low + high) / 2.0f;
            float x = (float)cx + dx * mid;
            float z = (float)cz + dz * mid;
            float edge = this.getEdgeNoise(x, z);
            if (edge > this.controlPoints.shallowOcean) {
                low = mid;
            } else {
                high = mid;
            }
            if (high - low < 10.0f) break;
        }
        return high;
    }

    @Override
    public float getDistanceToEdge(int cx, int cz, float dx, float dz, MutableVeci pos) {
        float distance = this.continentScale * 4;
        for (int i = 0; i < 10; ++i) {
            float x = (float)cx + dx * distance;
            float z = (float)cz + dz * distance;
            this.getNearestCenter(x, z, pos);
            distance += distance;
            if (pos.x == cx && pos.z == cz) continue;
            float low = 0.0f;
            float high = distance;
            for (int j = 0; j < 50; ++j) {
                float mid = (low + high) / 2.0f;
                float px = (float)cx + dx * mid;
                float pz = (float)cz + dz * mid;
                this.getNearestCenter(px, pz, pos);
                if (pos.x == cx && pos.z == cz) {
                    low = mid;
                } else {
                    high = mid;
                }
                if (high - low < 50.0f) break;
            }
            return high;
        }
        return distance;
    }

    protected float cellIdentity(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    protected float cellEdgeValue(float distance, float distance2) {
        EdgeFunc edge = EdgeFunc.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        if ((value = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range())) <= this.clampMin) {
            return 0.0f;
        }
        if (value >= this.clampMax) {
            return 1.0f;
        }
        return (value - this.clampMin) / this.clampRange;
    }

    protected float getShape(float x, float z, float edgeValue) {
        if (edgeValue >= this.controlPoints.inland) {
            return 1.0f;
        }
        float alpha = edgeValue / this.controlPoints.inland;
        return this.shape.getValue(x, z) * alpha;
    }
}

