/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.heightmap;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.module.Blender;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.settings.TerrainSettings;
import com.terraforged.core.settings.WorldSettings;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.n2d.func.EdgeFunc;
import com.terraforged.n2d.func.Interpolation;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.climate.Climate;
import com.terraforged.world.continent.Continent;
import com.terraforged.world.continent.ContinentLerper2;
import com.terraforged.world.continent.ContinentLerper3;
import com.terraforged.world.heightmap.ControlPoints;
import com.terraforged.world.heightmap.RegionConfig;
import com.terraforged.world.rivermap.RiverCache;
import com.terraforged.world.rivermap.Rivermap;
import com.terraforged.world.terrain.Terrain;
import com.terraforged.world.terrain.Terrains;
import com.terraforged.world.terrain.populator.TerrainPopulator;
import com.terraforged.world.terrain.provider.TerrainProvider;
import com.terraforged.world.terrain.region.RegionLerper;
import com.terraforged.world.terrain.region.RegionModule;
import com.terraforged.world.terrain.region.RegionSelector;

public class Heightmap
implements Populator {
    public static final int MOUNTAIN_SCALE = 1000;
    public static final float DEEP_OCEAN_VALUE = 0.1f;
    public static final float SHALLOW_OCEAN_VALUE = 0.25f;
    public static final float BEACH_VALUE = 0.327f;
    public static final float COAST_VALUE = 0.448f;
    public static final float INLAND_VALUE = 0.502f;
    protected final Terrains terrain;
    protected final Continent continentGenerator;
    protected final Populator regionModule;
    private final Climate climate;
    private final Populator root;
    private final RiverCache riverMap;
    private final TerrainProvider terrainProvider;

    public Heightmap(GeneratorContext context) {
        context = context.copy();
        this.terrain = context.terrain;
        Settings settings = context.settings;
        WorldSettings world = context.settings.world;
        ControlPoints controlPoints = new ControlPoints(world.controlPoints);
        Seed regionSeed = context.seed.nextSeed();
        Seed regionWarp = context.seed.nextSeed();
        int regionWarpScale = 400;
        int regionWarpStrength = 200;
        RegionConfig regionConfig = new RegionConfig(regionSeed.get(), context.settings.terrain.general.terrainRegionSize, Source.simplex(regionWarp.next(), regionWarpScale, 1), Source.simplex(regionWarp.next(), regionWarpScale, 1), regionWarpStrength);
        this.regionModule = new RegionModule(regionConfig);
        Module mountainShapeBase = Source.cellEdge(context.seed.next(), 1000, EdgeFunc.DISTANCE_2_ADD).warp(context.seed.next(), 333, 2, 250.0);
        Module mountainShape = mountainShapeBase.curve(Interpolation.CURVE3).clamp(0.0, 0.9).map(0.0, 1.0);
        this.terrainProvider = context.terrainFactory.create(context, regionConfig, this);
        RegionSelector terrainRegions = new RegionSelector(this.terrainProvider.getPopulators());
        TerrainPopulator terrainRegionBorders = TerrainPopulator.of(context.terrain.steppe, this.terrainProvider.getLandforms().getLandBase(), this.terrainProvider.getLandforms().plains(context.seed), settings.terrain.steppe);
        RegionLerper terrain = new RegionLerper(terrainRegionBorders, terrainRegions);
        TerrainPopulator mountains = this.register(context.terrain.mountainChain, this.terrainProvider.getLandforms().getLandBase(), this.terrainProvider.getLandforms().mountains(context.seed), settings.terrain.mountains);
        this.continentGenerator = world.continent.continentMode.create(context.seed, world);
        this.climate = new Climate(this.continentGenerator, context);
        Blender land = new Blender(mountainShape, terrain, mountains, 0.3f, 0.8f, 0.575f);
        ContinentLerper3 oceans = new ContinentLerper3(this.register(context.terrain.deepOcean, this.terrainProvider.getLandforms().deepOcean(context.seed.next())), this.register(context.terrain.ocean, Source.constant(context.levels.water(-7))), this.register(context.terrain.coast, Source.constant(context.levels.water)), controlPoints.deepOcean, controlPoints.shallowOcean, controlPoints.coast);
        this.root = new ContinentLerper2(oceans, land, controlPoints.shallowOcean, controlPoints.inland);
        this.riverMap = new RiverCache(this, context);
    }

    @Override
    public void apply(Cell cell, float x, float z) {
        this.applyBase(cell, x, z);
        this.applyRivers(cell, x, z);
        this.applyClimate(cell, x, z);
    }

    public void tag(Cell cell, float x, float z) {
        try (Resource<Cell> resource = Cell.pooled();){
            this.continentGenerator.apply(resource.get(), x, z);
            this.regionModule.apply(resource.get(), x, z);
            this.root.apply(resource.get(), x, z);
            cell.terrain = resource.get().terrain;
        }
    }

    public void applyBase(Cell cell, float x, float z) {
        cell.terrain = this.terrain.steppe;
        this.continentGenerator.apply(cell, x, z);
        this.regionModule.apply(cell, x, z);
        this.root.apply(cell, x, z);
    }

    public void applyRivers(Cell cell, float x, float z) {
        this.riverMap.getRivers(cell).apply(cell, x, z);
    }

    public void applyRivers(Cell cell, float x, float z, Rivermap rivermap) {
        rivermap.apply(cell, x, z);
    }

    public void applyClimate(Cell cell, float x, float z) {
        this.climate.apply(cell, x, z);
    }

    public Climate getClimate() {
        return this.climate;
    }

    public Continent getContinent() {
        return this.continentGenerator;
    }

    public RiverCache getRivers() {
        return this.riverMap;
    }

    public Populator getPopulator(Terrain terrain, int id) {
        return this.terrainProvider.getPopulator(terrain, id);
    }

    private TerrainPopulator register(Terrain terrain, Module variance) {
        TerrainPopulator populator = TerrainPopulator.of(terrain, variance);
        this.terrainProvider.registerMixable(populator);
        return populator;
    }

    private TerrainPopulator register(Terrain terrain, Module base, Module variance, TerrainSettings.Terrain settings) {
        TerrainPopulator populator = TerrainPopulator.of(terrain, base, variance, settings);
        this.terrainProvider.registerMixable(populator);
        return populator;
    }
}

