/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.heightmap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.core.tile.gen.TileCache;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.WorldGeneratorFactory;
import com.terraforged.world.heightmap.Heightmap;

public class WorldLookup {
    private final float waterLevel;
    private final float beachLevel;
    private final TileCache cache;
    private final Heightmap heightmap;
    private final GeneratorContext context;

    public WorldLookup(WorldGeneratorFactory factory, GeneratorContext context) {
        this.context = context;
        this.cache = context.cache;
        this.heightmap = factory.getHeightmap();
        this.waterLevel = context.levels.water;
        this.beachLevel = context.levels.water(5);
    }

    public Resource<Cell> get(int x, int z) {
        ChunkReader chunk = this.cache.getChunk(x >> 4, z >> 4);
        Resource<Cell> cell = Cell.pooled();
        cell.get().copy(chunk.getCell(x & 0xF, z & 0xF));
        return cell;
    }

    public Resource<Cell> getCell(int x, int z) {
        return this.getCell(x, z, false);
    }

    public Resource<Cell> getCell(int x, int z, boolean load) {
        Resource<Cell> resource = Cell.pooled();
        this.applyCell(resource.get(), x, z, load);
        return resource;
    }

    public void applyCell(Cell cell, int x, int z) {
        this.applyCell(cell, x, z, false);
    }

    public void applyCell(Cell cell, int x, int z, boolean load) {
        if (load && this.computeAccurate(cell, x, z)) {
            return;
        }
        if (!this.computeCached(cell, x, z)) {
            this.compute(cell, x, z);
        }
    }

    private boolean computeAccurate(Cell cell, int x, int z) {
        int rz;
        int rx = this.cache.chunkToRegion(x >> 4);
        Tile tile = this.cache.getRegion(rx, rz = this.cache.chunkToRegion(z >> 4));
        Cell c = tile.getCell(x, z);
        if (c != null) {
            cell.copy(c);
        }
        return cell.terrain != null;
    }

    private boolean computeCached(Cell cell, int x, int z) {
        int rz;
        int rx = this.cache.chunkToRegion(x >> 4);
        Tile tile = this.cache.getIfPresent(rx, rz = this.cache.chunkToRegion(z >> 4));
        if (tile != null) {
            Cell c = tile.getCell(x, z);
            if (c != null) {
                cell.copy(c);
            }
            return cell.terrain != null;
        }
        return false;
    }

    private void compute(Cell cell, int x, int z) {
        this.heightmap.apply(cell, x, z);
        if (cell.terrain == this.context.terrain.coast && cell.value > this.waterLevel && cell.value <= this.beachLevel) {
            cell.terrain = this.context.terrain.beach;
        }
    }
}

