/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.rivermap.river;

import com.terraforged.core.cell.Cell;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.n2d.func.CurveFunc;
import com.terraforged.n2d.func.SCurve;
import com.terraforged.n2d.source.Line;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.rivermap.river.RiverBounds;
import com.terraforged.world.rivermap.river.RiverConfig;
import com.terraforged.world.terrain.Terrains;
import com.terraforged.world.terrain.populator.TerrainPopulator;
import java.util.Random;

public class River
extends TerrainPopulator
implements Comparable<River> {
    public static final int VALLEY_WIDTH = 275;
    private static final float DEPTH_FADE_STRENGTH = 0.5f;
    private static final float MIN_WIDTH2 = 1.5f;
    public final boolean main;
    private final boolean connecting;
    private final float waterLine;
    private final float bedHeight;
    private final float extraBedDepth;
    private final float minBankHeight;
    private final float maxBankHeight;
    private final float bankAlphaMin;
    private final float bankAlphaMax;
    private final float bankAlphaRange;
    private final Module bankVariance;
    private final Line bed;
    private final Line banks;
    private final Line valley;
    private final CurveFunc valleyCurve;
    public final RiverConfig config;
    public final RiverBounds bounds;
    private final Terrains terrains;
    private final float depthFadeBias;
    private final float continentValleyModifier;
    private final float continentRiverModifier;

    public River(RiverBounds bounds, RiverConfig config, Settings settings, Terrains terrains, Levels levels) {
        super(terrains.river, Source.ZERO, Source.ZERO);
        Module bedIn = Source.constant(settings.fadeIn);
        Module banksIn = Source.constant(settings.fadeIn * 0.5);
        Module out = Source.constant(settings.fadeOut);
        Module bedWidth = Source.constant(config.bedWidth * config.bedWidth);
        Module bankWidth = Source.constant(config.bankWidth * config.bankWidth);
        Module valleyWidth = Source.constant(settings.valleySize * settings.valleySize);
        this.bounds = bounds;
        this.config = config;
        this.main = config.main;
        this.terrains = terrains;
        this.connecting = settings.connecting;
        this.waterLine = levels.water;
        this.bedHeight = config.bedHeight;
        this.extraBedDepth = levels.scale(1);
        this.minBankHeight = config.minBankHeight;
        this.maxBankHeight = config.maxBankHeight;
        this.valleyCurve = settings.valleyCurve;
        this.continentValleyModifier = settings.continentValleyModifier;
        this.continentRiverModifier = settings.continentRiverModifier;
        this.bankAlphaMin = this.minBankHeight;
        this.bankAlphaMax = Math.min(1.0f, this.minBankHeight + 0.35f);
        this.bankAlphaRange = this.bankAlphaMax - this.bankAlphaMin;
        this.bankVariance = Source.perlin(1234, 150, 1);
        this.depthFadeBias = 0.5f;
        this.bed = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), bedWidth, bedIn, out, (double)0.1f);
        this.banks = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), bankWidth, banksIn, out, (double)0.175f);
        this.valley = Source.line((double)bounds.x1(), (double)bounds.y1(), (double)bounds.x2(), (double)bounds.y2(), valleyWidth, Source.ZERO, Source.ZERO, (double)0.33f);
    }

    @Override
    public int compareTo(River o) {
        return Integer.compare(this.config.order, o.config.order);
    }

    @Override
    public void apply(Cell cell, float x, float z) {
        if (cell.value <= this.bedHeight) {
            return;
        }
        float valleyAlpha = this.valley.getValue(x, z);
        if (valleyAlpha == 0.0f) {
            return;
        }
        valleyAlpha = this.valleyCurve.apply(valleyAlpha);
        float continent = NoiseUtil.map(cell.continentEdge, 0.25f, 0.85f, 0.6f);
        float valleyMod = 1.0f - continent * this.continentValleyModifier;
        cell.riverMask *= 1.0f - valleyAlpha;
        float bankHeight = this.getBankHeight(cell, x, z);
        if (!this.carveValley(cell, valleyAlpha * valleyMod, bankHeight)) {
            return;
        }
        if (this.connecting && this.banks.clipEnd(x, z)) {
            return;
        }
        float mouthModifier = this.getMouthModifier(cell);
        float widthModifier = this.banks.getWidthModifier(x, z);
        float banksAlpha = this.banks.getValue(x, z, 1.5f, widthModifier / mouthModifier);
        if (banksAlpha == 0.0f) {
            return;
        }
        float riverMod = 1.0f - continent * this.continentRiverModifier;
        float depthAlpha = NoiseUtil.clamp(this.depthFadeBias + 0.5f * widthModifier, 0.0f, 1.0f);
        float bedHeight = NoiseUtil.lerp(bankHeight, this.bedHeight, depthAlpha);
        if (!this.carveBanks(cell, banksAlpha * riverMod, bedHeight)) {
            return;
        }
        float bedAlpha = this.bed.getValue(x, z);
        if (bedAlpha == 0.0f || cell.value <= bedHeight) {
            return;
        }
        this.carveBed(cell, bedHeight, bedAlpha);
    }

    private float getBankHeight(Cell cell, float x, float z) {
        float bankHeightAlpha = NoiseUtil.map(cell.value, this.bankAlphaMin, this.bankAlphaMax, this.bankAlphaRange);
        float bankHeightVariance = this.bankVariance.getValue(x, z);
        return NoiseUtil.lerp(this.minBankHeight, this.maxBankHeight, bankHeightAlpha * bankHeightVariance);
    }

    private float getBedHeight(float bankHeight, float depthAlpha) {
        return NoiseUtil.lerp(bankHeight, this.bedHeight, depthAlpha);
    }

    private boolean carveValley(Cell cell, float valleyAlpha, float bankHeight) {
        if (cell.value > bankHeight) {
            cell.value = NoiseUtil.lerp(cell.value, bankHeight, valleyAlpha);
        }
        return true;
    }

    private boolean carveBanks(Cell cell, float banksAlpha, float bedHeight) {
        if (cell.value > bedHeight) {
            banksAlpha = NoiseUtil.clamp(banksAlpha, 0.0f, 1.0f);
            cell.value = NoiseUtil.lerp(cell.value, bedHeight, banksAlpha);
            this.tag(cell, bedHeight);
            return true;
        }
        this.tag(cell, bedHeight);
        return false;
    }

    private void carveBed(Cell cell, float bedHeight, float bedAlpha) {
        cell.erosionMask = true;
        this.tag(cell, bedHeight);
        if (cell.value < bedHeight) {
            float extraBedHeight = NoiseUtil.lerp(bedHeight - this.extraBedDepth, bedHeight, bedAlpha);
            cell.value = River.getExtraBedHeight(cell.value, bedHeight, extraBedHeight);
        } else {
            cell.value = NoiseUtil.lerp(cell.value, bedHeight, bedAlpha);
        }
    }

    private void tag(Cell cell, float bedHeight) {
        if (cell.terrain.overridesRiver() && (cell.value < bedHeight || cell.value > this.waterLine)) {
            return;
        }
        cell.terrain = this.terrains.river;
    }

    private float getMouthModifier(Cell cell) {
        float modifier = NoiseUtil.map(cell.continentEdge, 0.0f, 0.5f, 0.5f);
        return modifier * modifier;
    }

    private static float getExtraBedHeight(float height, float bedHeight, float extraBedHeight) {
        if (height < extraBedHeight) {
            return extraBedHeight;
        }
        float alpha = (height - extraBedHeight) / (bedHeight - extraBedHeight);
        return NoiseUtil.lerp(extraBedHeight, bedHeight, alpha);
    }

    public static CurveFunc getValleyType(Random random) {
        int value = random.nextInt(100);
        if (value < 5) {
            return new SCurve(0.4f, 1.0f);
        }
        if (value < 30) {
            return new SCurve(4.0f, 5.0f);
        }
        if (value < 50) {
            return new SCurve(3.0f, 0.25f);
        }
        return new SCurve(2.0f, -0.5f);
    }

    public static class Settings {
        public float valleySize = 275.0f;
        public double fadeIn = 0.7f;
        public double fadeOut = 0.0;
        public boolean connecting = false;
        public float continentValleyModifier = 0.0f;
        public float continentRiverModifier = 0.0f;
        public CurveFunc valleyCurve = new SCurve(2.0f, -0.5f);
    }
}

