/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.terrain;

import com.terraforged.core.settings.Settings;
import com.terraforged.core.settings.WorldSettings;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.ITerrain;
import com.terraforged.world.terrain.TerrainType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Terrain
implements ITerrain.Delegate {
    private static final Map<String, Terrain> register = Collections.synchronizedMap(new HashMap());
    public static final Terrain NONE = new Terrain("none", -1.0, TerrainType.NONE);
    private final String name;
    private final float weight;
    private final TerrainType type;

    public Terrain(String name, TerrainType type) {
        this(name, 1.0, type);
    }

    public Terrain(String name, double weight, TerrainType type) {
        this.name = name;
        this.weight = (float)weight;
        this.type = type;
        register.put(name, this);
    }

    @Override
    public TerrainType getType() {
        return this.type;
    }

    public float getMax(float noise) {
        return 1.0f;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getHue() {
        return NoiseUtil.valCoord2D(this.name.hashCode(), 0, 0);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static Terrain ocean(final Settings settings) {
        return new Terrain("ocean", 0.0, TerrainType.SHALLOW_OCEAN){
            private final float max;
            {
                super(name, weight, type);
                this.max = new Levels((WorldSettings)settings.world).water;
            }

            @Override
            public float getMax(float noise) {
                return this.max;
            }
        };
    }

    public static Terrain deepOcean(final Settings settings) {
        return new Terrain("deep_ocean", 1.0, TerrainType.DEEP_OCEAN){
            private final float max;
            {
                super(name, weight, type);
                this.max = new Levels((WorldSettings)settings.world).water / 2.0f;
            }

            @Override
            public float getMax(float noise) {
                return this.max;
            }
        };
    }

    public static Terrain coast(final Settings settings) {
        return new Terrain("coast", 2.0, TerrainType.COAST){
            private final float max;
            {
                super(name, weight, type);
                this.max = new Levels(settings.world).ground(1);
            }

            @Override
            public float getMax(float noise) {
                return this.max + noise * 0.003921569f;
            }
        };
    }

    public static Terrain beach(final Settings settings) {
        return new Terrain("beach", 2.0, TerrainType.BEACH){
            private final float max;
            {
                super(name, weight, type);
                this.max = new Levels(settings.world).ground(1);
            }

            @Override
            public float getMax(float noise) {
                return this.max + noise * 0.003921569f;
            }
        };
    }

    public static Terrain lake(Settings settings) {
        return new Terrain("lake", 3.0, TerrainType.LAKE);
    }

    public static Terrain river(Settings settings) {
        return new Terrain("river", 3.0, TerrainType.RIVER);
    }

    public static Terrain riverBank(Settings settings) {
        return new Terrain("river_banks", 4.0, TerrainType.RIVER);
    }

    public static Terrain wetlands(Settings settings) {
        return new Terrain("wetlands", 5.0, TerrainType.WETLAND){

            @Override
            public boolean overridesRiver() {
                return true;
            }
        };
    }

    public static Terrain desert(Settings settings) {
        return new Terrain("desert", 5.0, TerrainType.FLATLAND);
    }

    public static Terrain steppe(Settings settings) {
        return new Terrain("steppe", settings.terrain.steppe.weight, TerrainType.FLATLAND);
    }

    public static Terrain plains(Settings settings) {
        return new Terrain("plains", settings.terrain.plains.weight, TerrainType.FLATLAND);
    }

    public static Terrain badlands(Settings settings) {
        return new Terrain("badlands", settings.terrain.badlands.weight, TerrainType.FLATLAND){

            @Override
            public float erosionModifier() {
                return 0.3f;
            }
        };
    }

    public static Terrain plateau(Settings settings) {
        return new Terrain("plateau", settings.terrain.plateau.weight, TerrainType.LOWLAND);
    }

    public static Terrain hills(Settings settings) {
        return new Terrain("hills", settings.terrain.hills.weight, TerrainType.LOWLAND);
    }

    public static Terrain dales(Settings settings) {
        return new Terrain("dales", settings.terrain.dales.weight, TerrainType.LOWLAND);
    }

    public static Terrain torridonian(Settings settings) {
        return new Terrain("torridonian", settings.terrain.torridonian.weight, TerrainType.HIGHLAND);
    }

    public static Terrain mountains(Settings settings) {
        return new Terrain("mountains", settings.terrain.mountains.weight, TerrainType.HIGHLAND){

            @Override
            public boolean isMountain() {
                return true;
            }

            @Override
            public boolean overridesRiver() {
                return true;
            }
        };
    }

    public static Terrain mountainChain(Settings settings) {
        return new Terrain("mountain_chain", settings.terrain.mountains.weight, TerrainType.HIGHLAND){

            @Override
            public boolean isMountain() {
                return true;
            }

            @Override
            public boolean overridesRiver() {
                return true;
            }
        };
    }

    public static Terrain volcano(Settings settings) {
        return new Terrain("volcano", settings.terrain.volcano.weight, TerrainType.HIGHLAND);
    }

    public static Terrain volcanoPipe(Settings settings) {
        return new Terrain("volcano_pipe", settings.terrain.volcano.weight, TerrainType.HIGHLAND);
    }

    public static Optional<Terrain> get(String name) {
        return Optional.ofNullable(register.get(name));
    }

    public static List<Terrain> getRegistered() {
        return new ArrayList<Terrain>(register.values());
    }
}

