/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.world.structures;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.util.RegistryHandler;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerGrassPieces;
import com._idrae.towers_of_the_wild.world.structures.DerelictTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.IceTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.JungleTowerPieces;
import com._idrae.towers_of_the_wild.world.structures.TowerPieces;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TowerStructure
extends ScatteredStructure<NoFeatureConfig> {
    public static final String NAME = "towers_of_the_wild:Tower";
    private static int FEATURE_DISTANCE;
    private static final int FEATURE_SEPARATION = 5;

    public TowerStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51491_1_) {
        super(p_i51491_1_);
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 3;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> generator, Random random, int chunkX, int chunkZ, int offsetX, int offsetZ) {
        FEATURE_DISTANCE = TowersOfTheWildConfig.rarity;
        int chunkPosX = chunkX + FEATURE_DISTANCE * offsetX;
        int chunkPosZ = chunkZ + FEATURE_DISTANCE * offsetZ;
        int chunkPosX1 = chunkPosX < 0 ? chunkPosX - FEATURE_DISTANCE + 1 : chunkPosX;
        int chunkPosZ1 = chunkPosZ < 0 ? chunkPosZ - FEATURE_DISTANCE + 1 : chunkPosZ;
        int lvt_13_1_ = chunkPosX1 / FEATURE_DISTANCE;
        int lvt_14_1_ = chunkPosZ1 / FEATURE_DISTANCE;
        ((SharedSeedRandom)random).func_202427_a(generator.func_202089_c(), lvt_13_1_, lvt_14_1_, 16897777);
        lvt_13_1_ *= FEATURE_DISTANCE;
        lvt_14_1_ *= FEATURE_DISTANCE;
        return new ChunkPos(lvt_13_1_ += random.nextInt(FEATURE_DISTANCE - 5), lvt_14_1_ += random.nextInt(FEATURE_DISTANCE - 5));
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        return super.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)config);
    }

    protected int func_202382_c() {
        return 16897777;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i225806_1_, int p_i225806_2_, int p_i225806_3_, MutableBoundingBox p_i225806_4_, int p_i225806_5_, long p_i225806_6_) {
            super(p_i225806_1_, p_i225806_2_, p_i225806_3_, p_i225806_4_, p_i225806_5_, p_i225806_6_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            NoFeatureConfig nofeatureconfig = (NoFeatureConfig)generator.func_202087_b(biomeIn, (Structure)RegistryHandler.TOWER.get());
            int i = chunkX * 16;
            int j = chunkZ * 16;
            BlockPos blockpos = new BlockPos(i + 3, 90, j + 3);
            Rotation rotation = Rotation.NONE;
            if (biomeIn.func_201856_r() == Biome.Category.JUNGLE) {
                JungleTowerPieces.addPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, nofeatureconfig);
            } else if (biomeIn.func_201856_r() == Biome.Category.ICY) {
                IceTowerPieces.addPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, nofeatureconfig);
            } else if (this.field_214631_d.nextInt(100) < TowersOfTheWildConfig.derelictTowerProportion) {
                blockpos = new BlockPos(i, 90, j);
                if (biomeIn.func_201856_r() == Biome.Category.PLAINS || biomeIn.func_201856_r() == Biome.Category.FOREST || biomeIn.func_201856_r() == Biome.Category.TAIGA || biomeIn.func_201856_r() == Biome.Category.SAVANNA || biomeIn.func_201856_r() == Biome.Category.EXTREME_HILLS) {
                    DerelictTowerGrassPieces.addPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, nofeatureconfig);
                } else {
                    DerelictTowerPieces.addPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, nofeatureconfig);
                }
            } else {
                TowerPieces.addPieces(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d, nofeatureconfig);
            }
            this.func_202500_a();
        }
    }
}

