/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.screen.world;

import com.matez.wildnature.client.gui.screen.ScreenUtils;
import com.matez.wildnature.init.Main;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;

public class WNWorldCreateProgress
extends Screen {
    private final TrackingChunkStatusListener trackingProgress;
    private int centerWidth;
    private int centerHeight;
    private int screenX1;
    private int screenY1;
    private int screenX2;
    private int screenY2;
    private int sampleSize = 64;
    private int worldSize = 256;
    private final int[][][] blockData = new int[this.sampleSize][this.worldSize][this.sampleSize];
    private BlockPos playerPosition = new BlockPos(0, 0, 0);
    private World world;
    private PlayerEntity entity;

    public WNWorldCreateProgress(TrackingChunkStatusListener trackingProgress) {
        super((ITextComponent)new StringTextComponent("World Loading Progress"));
        this.trackingProgress = trackingProgress;
    }

    public void removed() {
        NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.loading.done", (Object[])new Object[0]));
    }

    public void fill(int x1, int y1, int x2, int y2) {
        WNWorldCreateProgress.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)-1072689136);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected void init() {
        this.centerWidth = this.width / 2;
        this.centerHeight = this.height / 2;
        int[] proportionalSize = ScreenUtils.getByResolution(this.width, this.height, 20, 20, 16, 9);
        this.screenX1 = proportionalSize[0];
        this.screenX2 = proportionalSize[2];
        this.screenY1 = proportionalSize[1];
        this.screenY2 = proportionalSize[3];
    }

    public void tick() {
        if (this.world == null) {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                this.world = Minecraft.func_71410_x().field_71441_e;
            } else if (Main.runningWorld != null) {
                this.world = Main.runningWorld;
            }
        }
        if (this.entity == null) {
            // empty if block
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderUIScreen();
        this.renderMapScreen();
    }

    private void renderUIScreen() {
        this.renderBackground();
        this.fill(this.screenX1, this.screenY1, this.screenX2, this.screenY2);
    }

    private void renderMapScreen() {
    }
}

