/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.gui.tileEntities.item;

import com.matez.wildnature.client.gui.initGuis;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static ArrayList<Block> SUPPORTED_BLOCKS = new ArrayList();
    private ItemStack placedStack;
    private Direction facing = Direction.NORTH;
    private PlayerEntity eatingPlayer;
    private int eatingTime = 0;
    private Random rand = new Random();
    int eatingLeftToReset = 5;
    int oldEatingTime;

    public ItemTileEntity() {
        super(initGuis.ITEM_TILE_ENTITY);
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public boolean hasPlacedStack() {
        return this.placedStack != null && !this.placedStack.func_190926_b();
    }

    public ItemStack getPlacedStack() {
        return this.placedStack;
    }

    public void setPlacedStack(ItemStack placedStack) {
        this.placedStack = placedStack;
    }

    public void destroy(World world, BlockPos pos) {
        this.dropItemStack(world, pos);
        this.func_145843_s();
    }

    public void removeItemStack() {
        this.placedStack = null;
    }

    public void addItemStack(World world, BlockPos pos, ItemStack stack) {
        this.dropItemStack(world, pos);
        this.placedStack = stack;
    }

    public void dropItemStack(World world, BlockPos pos) {
        if (this.hasPlacedStack()) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.placedStack);
            this.removeItemStack();
        }
    }

    public void setEatingPlayer(PlayerEntity eatingPlayer) {
        this.eatingPlayer = eatingPlayer;
    }

    public void eat(PlayerEntity entity) {
        if (this.placedStack.func_77973_b().func_219967_s() != null && entity.func_71043_e(this.placedStack.func_77973_b().func_219967_s().func_221468_d())) {
            if (this.eatingPlayer == null) {
                this.eatingPlayer = entity;
                this.eatingTime = 0;
            } else if (this.eatingPlayer == entity) {
                ++this.eatingTime;
                this.addItemParticles(this.eatingPlayer, this.placedStack, 1);
                this.eatingPlayer.func_184185_a(this.eatingPlayer.func_213353_d(this.placedStack), 0.5f + 0.5f * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                if (this.eatingTime >= this.placedStack.func_77988_m() / 4) {
                    this.placedStack.func_77950_b(entity.func_130014_f_(), (LivingEntity)entity);
                    this.eatingTime = 0;
                    this.eatingPlayer = null;
                }
            }
        }
    }

    private void addItemParticles(PlayerEntity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3d vec3d = new Vec3d(((double)this.rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-this.rand.nextFloat()) * 0.6 - 0.3;
            Vec3d vec3d1 = new Vec3d(((double)this.rand.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_72441_c(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
            if (this.field_145850_b instanceof ServerWorld) {
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.0);
                continue;
            }
            this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public void func_73660_a() {
        if (this.eatingTime != 0) {
            if (this.oldEatingTime == this.eatingTime) {
                --this.eatingLeftToReset;
                if (this.eatingLeftToReset <= 0) {
                    this.eatingPlayer = null;
                    this.eatingTime = 0;
                    this.eatingLeftToReset = 5;
                }
            } else {
                this.eatingLeftToReset = 5;
            }
        } else {
            this.eatingLeftToReset = 5;
        }
        this.oldEatingTime = this.eatingTime;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.placedStack = Utilities.loadItem(compound);
        if (compound.func_74764_b("facing")) {
            this.facing = Direction.func_176731_b((int)compound.func_74762_e("facing"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.hasPlacedStack()) {
            Utilities.saveItem(compound, this.placedStack);
        }
        compound.func_74768_a("facing", this.facing.func_176736_b());
        return super.func_189515_b(compound);
    }
}

