/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.client.music;

import com.matez.wildnature.client.sounds.SoundRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;

public class WNMusic {
    public static ArrayList<MusicType> musicTypes = new ArrayList();

    public WNMusic() {
        System.out.println("Registering Ambient Music Module");
        new MusicType(null, DimensionType.field_223227_a_, Biome.RainType.NONE, DayTime.NONE, MusicPosition.UNDERGROUND, 0, 1.0, SoundRegistry.CAVE1);
        System.out.println("Registered musics for " + musicTypes.size() + " biomes.");
    }

    public static enum MusicPosition {
        UNDERGROUND,
        UNDERWATER,
        SURFACE,
        NONE;

    }

    public static enum DayTime {
        DAY,
        NIGHT,
        NONE;

    }

    public static class MusicType {
        private Biome biome;
        private DimensionType dimension;
        private Biome.RainType rainType;
        private DayTime dayTime;
        private MusicPosition position;
        private int repeatDelay = 0;
        private double volume = 0.0;
        private ArrayList<SoundEvent> soundEvents;

        public MusicType(Biome biome, DimensionType dimension, Biome.RainType type, DayTime dayTime, MusicPosition position, int repeatDelay, double volume, SoundEvent ... events) {
            this.biome = biome;
            this.dimension = dimension;
            this.rainType = type;
            this.dayTime = dayTime;
            this.position = position;
            this.repeatDelay = repeatDelay;
            this.volume = volume;
            this.soundEvents = new ArrayList<SoundEvent>(Arrays.asList(events));
            musicTypes.add(this);
        }

        public double getVolume() {
            return this.volume;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public DimensionType getDimension() {
            return this.dimension;
        }

        public boolean canPlayAnywhere(DimensionType dimension) {
            return this.biome == null && this.dimension == dimension;
        }

        public ArrayList<SoundEvent> getSoundEvents() {
            return this.soundEvents;
        }

        public Biome.RainType getRainType() {
            return this.rainType;
        }

        public int getRepeatDelay() {
            return this.repeatDelay;
        }

        public DayTime getDayTime() {
            return this.dayTime;
        }

        public MusicPosition getPosition() {
            return this.position;
        }

        public boolean contains(ISound sound) {
            if (sound == null) {
                return false;
            }
            for (SoundEvent e : this.soundEvents) {
                if (e.func_187503_a() != sound.func_147650_b()) continue;
                return true;
            }
            return false;
        }

        public static void applySameAs(DimensionType dimension, Biome biome, Biome as, Biome.RainType type, DayTime dayTime, MusicPosition position, int repeatDelay, double volume) {
            for (MusicType m : musicTypes) {
                Biome b = m.getBiome();
                if (b != biome) continue;
                new MusicType(as, dimension, type, dayTime, position, repeatDelay, volume, (SoundEvent[])m.getSoundEvents().toArray());
            }
        }
    }
}

