/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import java.text.SimpleDateFormat;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class DungeonCommanderLogic
extends CommandBlockLogic {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    private ITextComponent lastOutput;
    private String commandStored = "";
    private ITextComponent customName = new StringTextComponent("@");

    public int func_145760_g() {
        return this.successCount;
    }

    public void func_184167_a(int successCountIn) {
        this.successCount = successCountIn;
    }

    public ITextComponent func_145749_h() {
        return this.lastOutput == null ? new StringTextComponent("") : this.lastOutput;
    }

    public CompoundNBT func_189510_a(CompoundNBT compound) {
        compound.func_74778_a("Command", this.commandStored);
        compound.func_74768_a("SuccessCount", this.successCount);
        compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        compound.func_74757_a("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            compound.func_74778_a("LastOutput", ITextComponent.Serializer.func_150696_a((ITextComponent)this.lastOutput));
        }
        compound.func_74757_a("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution > 0L) {
            compound.func_74772_a("LastExecution", this.lastExecution);
        }
        return compound;
    }

    public void func_145759_b(CompoundNBT nbt) {
        this.commandStored = nbt.func_74779_i("Command");
        this.successCount = nbt.func_74762_e("SuccessCount");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomName"));
        }
        if (nbt.func_150297_b("TrackOutput", 1)) {
            this.trackOutput = nbt.func_74767_n("TrackOutput");
        }
        if (nbt.func_150297_b("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("LastOutput"));
            }
            catch (Throwable throwable) {
                this.lastOutput = new StringTextComponent(throwable.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        if (nbt.func_74764_b("UpdateLastExecution")) {
            this.updateLastExecution = nbt.func_74767_n("UpdateLastExecution");
        }
        this.lastExecution = this.updateLastExecution && nbt.func_74764_b("LastExecution") ? nbt.func_74763_f("LastExecution") : -1L;
    }

    public void func_145752_a(String command) {
        this.commandStored = command;
        this.successCount = 0;
    }

    public String func_145753_i() {
        return this.commandStored;
    }

    public boolean func_145755_a(World worldIn) {
        if (!worldIn.field_72995_K && worldIn.func_82737_E() != this.lastExecution) {
            if ("Searge".equalsIgnoreCase(this.commandStored)) {
                this.lastOutput = new StringTextComponent("#itzlipofutzli");
                this.successCount = 1;
                return true;
            }
            this.successCount = 0;
            MinecraftServer minecraftserver = this.func_195043_d().func_73046_m();
            if (minecraftserver != null && minecraftserver.func_175578_N() && minecraftserver.func_82356_Z() && !StringUtils.func_151246_b((String)this.commandStored)) {
                try {
                    this.lastOutput = null;
                    CommandSource commandsource = this.func_195042_h().func_197029_a((p_209527_1_, p_209527_2_, p_209527_3_) -> {
                        if (p_209527_2_) {
                            ++this.successCount;
                        }
                    });
                    minecraftserver.func_195571_aL().func_197059_a(commandsource, this.commandStored);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Executing command block");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Command to be executed");
                    crashreportcategory.func_189529_a("Command", this::func_145753_i);
                    crashreportcategory.func_189529_a("Name", () -> this.func_207404_l().getString());
                    throw new ReportedException(crashreport);
                }
            }
            this.lastExecution = this.updateLastExecution ? worldIn.func_82737_E() : -1L;
            return true;
        }
        return false;
    }

    public ITextComponent func_207404_l() {
        return this.customName;
    }

    public void func_207405_b(ITextComponent nameIn) {
        this.customName = nameIn;
    }

    public void func_145747_a(ITextComponent component) {
    }

    public abstract ServerWorld func_195043_d();

    public abstract void func_145756_e();

    public void func_145750_b(@Nullable ITextComponent lastOutputMessage) {
        this.lastOutput = lastOutputMessage;
    }

    public void func_175573_a(boolean shouldTrackOutput) {
        this.trackOutput = shouldTrackOutput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_175571_m() {
        return this.trackOutput;
    }

    public boolean func_175574_a(PlayerEntity playerIn) {
        if (!playerIn.func_195070_dx()) {
            return false;
        }
        if (playerIn.func_130014_f_().field_72995_K) {
            // empty if block
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Vec3d func_210165_f();

    public abstract CommandSource func_195042_h();

    public boolean func_195039_a() {
        return this.func_195043_d().func_82736_K().func_223586_b(GameRules.field_223611_n) && this.trackOutput;
    }

    public boolean func_195040_b() {
        return this.trackOutput;
    }

    public boolean func_195041_r_() {
        return false;
    }
}

