/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.commands;

import com.matez.wildnature.init.Main;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;

public class StructureArgument
implements ArgumentType<SchemFeature> {
    public static final DynamicCommandExceptionType INVALID_STRUCTURE_EXCEPTION = new DynamicCommandExceptionType(biome -> new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "This structure does not exist.")));
    private ArrayList<ResourceLocation> suggestions = new ArrayList();

    public static StructureArgument createArgument() {
        return new StructureArgument();
    }

    public SchemFeature parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
        for (Map.Entry<String, SchemFeature> stringSchemFeatureEntry : SchemFeature.schemFeatures.entrySet()) {
            if (!location.func_110623_a().equals(stringSchemFeatureEntry.getKey())) continue;
            return stringSchemFeatureEntry.getValue();
        }
        throw INVALID_STRUCTURE_EXCEPTION.create((Object)location);
    }

    public static SchemFeature getValue(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return (SchemFeature)((Object)context.getArgument(name, SchemFeature.class));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        if (this.suggestions.isEmpty()) {
            for (Map.Entry<String, SchemFeature> stringSchemFeatureEntry : SchemFeature.schemFeatures.entrySet()) {
                this.suggestions.add(new ResourceLocation("wildnature", stringSchemFeatureEntry.getKey()));
            }
        }
        return ISuggestionProvider.func_197014_a(this.suggestions, (SuggestionsBuilder)suggestionsBuilder);
    }

    public static int generateStructure(CommandSource cs, ServerPlayerEntity player, BlockPos pos, SchemFeature feature) {
        ServerWorld w = cs.func_197023_e();
        boolean success = feature.placeStructure((IWorld)w, (ChunkGenerator<? extends GenerationSettings>)w.func_72863_F().func_201711_g(), w.func_201674_k(), pos, new NoFeatureConfig());
        ITextComponent output = null;
        if (!success) {
            output = new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to place blocks."));
            Main.sendChatMessage((PlayerEntity)player, output);
            return 0;
        }
        if (feature.getAddedBlocks().isEmpty()) {
            output = new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Placed " + TextFormatting.GOLD + "0" + TextFormatting.RED + " blocks."));
            Main.sendChatMessage((PlayerEntity)player, output);
            return 0;
        }
        String name = ((Object)((Object)feature)).getClass().getSimpleName().toLowerCase();
        output = new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Generated " + TextFormatting.LIGHT_PURPLE + name + TextFormatting.GREEN + " on " + TextFormatting.YELLOW + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p() + TextFormatting.GREEN + ". Placed " + TextFormatting.GOLD + feature.getAddedBlocks().size() + TextFormatting.GREEN + " blocks."));
        Main.sendChatMessage((PlayerEntity)player, output);
        return 1;
    }
}

