/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.type.animal.deer;

import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.entity.AI.BreakBlocksGoal;
import com.matez.wildnature.common.entity.AI.FamilyBreedGoal;
import com.matez.wildnature.common.entity.AI.FollowMotherGoal;
import com.matez.wildnature.common.entity.EntityRegistry;
import com.matez.wildnature.common.entity.type.animal.IFamily;
import com.matez.wildnature.util.lists.WNItems;
import com.matez.wildnature.util.other.Utilities;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbstractDeerEntity
extends AnimalEntity
implements IFamily {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{WNItems.BELLADONNA_FRUIT, WNItems.BLUEBERRY, WNItems.BLACKBERRY, WNItems.CRANBERRIES, WNItems.WILD_STRAWBERRY, Items.field_151174_bG, Items.field_185164_cV});
    public IFamily.Gender gender = null;
    private int eatingTimer;
    private EatGrassGoal eatGrassGoal;
    public Predicate<LivingEntity> predicate = new Predicate<LivingEntity>(){

        @Override
        public boolean test(LivingEntity entity) {
            return true;
        }
    };

    public AbstractDeerEntity(EntityType<? extends AbstractDeerEntity> deer, World world) {
        super(deer, world);
    }

    public AbstractDeerEntity(EntityType<? extends AbstractDeerEntity> deer, World world, IFamily.Gender g) {
        super(deer, world);
        this.gender = g;
    }

    public AbstractDeerEntity(World worldIn) {
        super(EntityRegistry.BOAR, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 35.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, VillagerEntity.class, 25.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PillagerEntity.class, 25.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 25.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreakBlocksGoal((CreatureEntity)this, 0.9f, 8, Blocks.field_150469_bN, Blocks.field_185773_cZ));
        this.field_70714_bg.func_75776_a(6, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(7, (Goal)new FamilyBreedGoal(this, 1.0, this.getGender()));
        this.field_70714_bg.func_75776_a(8, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(9, (Goal)new FollowMotherGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(10, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.eatingTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
    }

    protected SoundEvent func_184639_G() {
        if (Utilities.rint(0, 2) != 0) {
            if (this.gender == IFamily.Gender.FEMALE) {
                return SoundRegistry.DEER_DOEGRUNT;
            }
            if (this.gender == IFamily.Gender.MALE) {
                return SoundRegistry.DEER_BUCKGRUNT;
            }
            return SoundRegistry.DEER_CONTACT;
        }
        switch (Utilities.rint(0, 2)) {
            case 0: {
                return SoundRegistry.DEER_SNORT;
            }
            case 1: {
                return SoundRegistry.DEER_SNORT2;
            }
            case 2: {
                return SoundRegistry.DEER_CONTACT;
            }
        }
        return SoundRegistry.DEER_SNORT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.DEER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DEER_DEATH;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public AbstractDeerEntity createChild(AgeableEntity p_90011_1_) {
        return null;
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return TEMPTATION_ITEMS.test(p_70877_1_);
    }

    @Override
    public IFamily.Gender getGender() {
        return this.gender;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.eatingTimer = Math.max(0, this.eatingTimer - 1);
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatingTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.eatingTimer <= 0) {
            return 0.0f;
        }
        if (this.eatingTimer >= 4 && this.eatingTimer <= 36) {
            return 1.0f;
        }
        return this.eatingTimer < 4 ? ((float)this.eatingTimer - p_70894_1_) / 4.0f : -((float)(this.eatingTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatingTimer > 4 && this.eatingTimer <= 36) {
            float f = ((float)(this.eatingTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatingTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }
}

