/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.entity.type.animal.duck;

import com.matez.wildnature.client.sounds.SoundRegistry;
import com.matez.wildnature.common.entity.AI.CreateGroupGoal;
import com.matez.wildnature.common.entity.AI.DuckSwimGoal;
import com.matez.wildnature.common.entity.AI.FamilyBreedGoal;
import com.matez.wildnature.common.entity.AI.FindItemsGoal;
import com.matez.wildnature.common.entity.AI.FollowMotherGoal;
import com.matez.wildnature.common.entity.AI.Movement.FlyingMovementControllerOld;
import com.matez.wildnature.common.entity.AI.RandomFlyingGoal;
import com.matez.wildnature.common.entity.AI.RandomSwimmingGoal;
import com.matez.wildnature.common.entity.AI.RandomWalkingGoal;
import com.matez.wildnature.common.entity.AI.StayInGroup;
import com.matez.wildnature.common.entity.AI.TemptGoal;
import com.matez.wildnature.common.entity.EntityRegistry;
import com.matez.wildnature.common.entity.type.animal.IFamily;
import com.matez.wildnature.init.Main;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractDuckEntity
extends AnimalEntity
implements IFamily,
IFlyingAnimal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU, Items.field_151025_P});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
    public IFamily.Gender gender = null;
    public boolean isGroupLeader = false;
    public boolean breed = false;
    public boolean sleeping = false;
    public AbstractDuckEntity leader = this;
    public ArrayList<AbstractDuckEntity> group = new ArrayList();
    public int eatTicks = 0;
    public boolean flying = false;
    public boolean angry = false;
    public boolean wasAngry = true;
    public int angryFlight = 0;
    public PathNavigator groundNavigator;
    public PathNavigator flyingNavigator;
    public PathNavigator waterNavigator;
    public MovementController groundMovementController = new MovementController((MobEntity)this);
    public MovementController flyingMovementController = new FlyingMovementControllerOld((MobEntity)this, 0.3f);
    public static final Predicate<ItemEntity> predicate = item -> !item.func_174874_s() && item.func_70089_S() && AbstractDuckEntity.checkIfContains(TEMPTATION_ITEMS.func_193365_a(), item.func_92059_d().func_77973_b());
    public static final Predicate<LivingEntity> leaderPredicate = entity -> {
        AbstractDuckEntity duck;
        return entity instanceof AbstractDuckEntity && ((duck = (AbstractDuckEntity)entity).isGroupLeader() || duck == duck.getLeader()) && duck.getGroup().size() > 1;
    };

    public AbstractDuckEntity(EntityType<? extends AbstractDuckEntity> type, World worldIn) {
        super(type, worldIn);
        this.init();
    }

    public AbstractDuckEntity(EntityType<? extends AbstractDuckEntity> type, World worldIn, IFamily.Gender g) {
        super(type, worldIn);
        this.gender = g;
        this.init();
    }

    public AbstractDuckEntity(World worldIn) {
        super(EntityRegistry.DRAKE, worldIn);
        this.init();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.func_180425_c().func_177956_o() < worldIn.func_181545_F()) {
            this.func_70107_b(this.func_180425_c().func_177958_n(), worldIn.func_181545_F(), this.func_180425_c().func_177952_p());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, this.func_130014_f_());
        this.flyingNavigator = new FlyingPathNavigator((MobEntity)this, this.func_130014_f_());
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, this.func_130014_f_());
        return this.groundNavigator;
    }

    public void init() {
        this.func_184644_a(PathNodeType.WATER, 20.0f);
        this.groundNavigator.func_212239_d(true);
        this.waterNavigator.func_212239_d(true);
        this.flyingNavigator.func_212239_d(true);
    }

    public PathNavigator func_70661_as() {
        if (this.func_70638_az() == null && this.func_70643_av() == null && !this.flying || this.getGender() == IFamily.Gender.CHILD) {
            if (this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.field_70765_h = this.groundMovementController;
                return this.waterNavigator;
            }
            this.field_70699_by = this.groundNavigator;
            this.field_70765_h = this.groundMovementController;
            return this.groundNavigator;
        }
        this.flying = true;
        this.field_70699_by = this.flyingNavigator;
        this.field_70765_h = this.flyingMovementController;
        return this.flyingNavigator;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new DuckSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new CreateGroupGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, FoxEntity.class, 16.0f, (double)0.8f, (double)1.2f));
        this.field_70714_bg.func_75776_a(4, (Goal)new DuckAvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 16.0f, 0.7f, 1.3f));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractDuckEntity.class, 16.0f, (double)0.7f, (double)1.3f, leaderPredicate));
        this.field_70714_bg.func_75776_a(6, (Goal)new FamilyBreedGoal(this, 1.0, this.getGender()));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMotherGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new StayInGroup(this, 8.0, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new FindItemsGoal(this, predicate));
        this.field_70714_bg.func_75776_a(12, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 220.0f, 20, 4));
        this.field_70714_bg.func_75776_a(13, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 120, 20, 10));
        this.field_70714_bg.func_75776_a(14, (Goal)new RandomFlyingGoal((CreatureEntity)this, 1.3, 60));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, AbstractDuckEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(16, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
        }
        if (this.func_70608_bn()) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        }
        if (Utilities.rint(0, 100) != 0 || this.func_70608_bn() || !this.func_70090_H() || !this.angry) {
            // empty if block
        }
        if (this.angry) {
            if (this.angryFlight == 100) {
                this.func_184185_a(SoundRegistry.DUCK_SCARED, 1.0f, 1.0f);
            }
            if (this.angryFlight > 0) {
                --this.angryFlight;
                this.func_70657_f(1.5f);
                this.func_191989_p(4.0f);
            } else {
                this.angry = false;
                this.angryFlight = 0;
            }
        }
        if (this.func_70090_H() && (this.func_213322_ci().field_72450_a != 0.0 || this.func_213322_ci().field_72449_c != 0.0)) {
            Vec3d vec3d = this.func_70676_i(0.0f);
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.func_226277_ct_() - vec3d.field_72450_a, this.func_226278_cu_() - vec3d.field_72448_b, this.func_226281_cx_() - vec3d.field_72449_c, 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.func_226277_ct_() - vec3d.field_72450_a, this.func_226278_cu_() - vec3d.field_72448_b, this.func_226281_cx_() - vec3d.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.85f : sizeIn.field_220316_b * 0.92f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(2.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vec3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && this.getGender() == IFamily.Gender.FEMALE && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)Items.field_151110_aK);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
        ++this.eatTicks;
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (this.canEatItem(itemstack)) {
            if (this.eatTicks > 600) {
                ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                if (!itemstack1.func_190926_b()) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                }
                this.eatTicks = 0;
            } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            }
        }
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return !this.func_70608_bn() && (this.field_70122_E || this.field_70171_ac) && AbstractDuckEntity.checkIfContains(TEMPTATION_ITEMS.func_193365_a(), itemStackIn.func_77973_b());
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        if (this.getGender() == IFamily.Gender.CHILD) {
            return SoundRegistry.DUCK_CHICK;
        }
        return SoundRegistry.DUCK_QUACK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.getGender() == IFamily.Gender.CHILD) {
            return SoundRegistry.DUCK_CHICK;
        }
        return SoundRegistry.DUCK_SCARED;
    }

    protected SoundEvent func_184615_bR() {
        if (this.getGender() == IFamily.Gender.CHILD) {
            return SoundRegistry.DUCK_CHICK;
        }
        return SoundRegistry.DUCK_SCARED;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.1f, 1.0f);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187549_bG;
    }

    public AbstractDuckEntity createChild(AgeableEntity ageable) {
        return (AbstractDuckEntity)EntityRegistry.DUCKLING.func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    protected int func_70693_a(PlayerEntity player) {
        return super.func_70693_a(player);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
        if (compound.func_74764_b("isBreed")) {
            this.breed = compound.func_74767_n("isBreed");
        }
        if (compound.func_74764_b("isSleeping")) {
            this.sleeping = compound.func_74767_n("isSleeping");
        }
        if (compound.func_74764_b("leaderEntity") && !this.field_70170_p.func_201670_d()) {
            Entity e = ((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(compound.func_74779_i("leaderEntity")));
            if (e instanceof AbstractDuckEntity) {
                this.leader = (AbstractDuckEntity)e;
                Main.LOGGER.debug((Object)("My leader is " + this.leader == this + " " + this.leader ? 1 : 0));
            }
        } else {
            Main.LOGGER.debug("Cannot get leader");
        }
        if (compound.func_74764_b("isGroupLeader")) {
            this.isGroupLeader = compound.func_74767_n("isGroupLeader");
            if (!this.field_70170_p.func_201670_d() && compound.func_74764_b("duckGroup")) {
                ListNBT l = (ListNBT)compound.func_74781_a("duckGroup");
                assert (l != null);
                for (INBT nbt : l) {
                    Main.LOGGER.info("Reading nbt...");
                    String s = ((CompoundNBT)nbt).func_74779_i("uuid");
                    Entity e = ((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(s));
                    if (!(e instanceof AbstractDuckEntity)) continue;
                    Main.LOGGER.info("Readed from uuid " + this.group.size() + " : " + e);
                    this.group.add((AbstractDuckEntity)e);
                }
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        compound.func_74757_a("isGroupLeader", this.isGroupLeader);
        compound.func_74757_a("isBreed", this.breed);
        compound.func_74757_a("isSleeping", this.sleeping);
        compound.func_74778_a("leaderEntity", this.getLeader().func_110124_au().toString());
        ListNBT l = new ListNBT();
        for (AbstractDuckEntity duck : this.group) {
            CompoundNBT n = new CompoundNBT();
            n.func_74778_a("uuid", duck.func_110124_au().toString());
            l.add((Object)n);
        }
        compound.func_218657_a("duckGroup", (INBT)l);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_184207_aI();
    }

    @Override
    public IFamily.Gender getGender() {
        return this.gender;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        Main.LOGGER.debug("breed ");
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof AbstractDuckEntity) {
            if (((AbstractDuckEntity)otherAnimal).getGender() == this.getGender()) {
                return false;
            }
            if (((AbstractDuckEntity)otherAnimal).getGender() == IFamily.Gender.CHILD) {
                return false;
            }
            Main.LOGGER.debug("breed y");
            return this.func_70880_s() && otherAnimal.func_70880_s();
        }
        return false;
    }

    public boolean func_70608_bn() {
        return this.sleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.sleeping = sleeping;
    }

    public ArrayList<AbstractDuckEntity> getGroup() {
        return this.getLeader().group;
    }

    public boolean isGroupLeader() {
        return this.isGroupLeader;
    }

    public void setGroupLeader(boolean groupLeader) {
        this.leader.isGroupLeader = groupLeader;
    }

    public void setGroup(ArrayList<AbstractDuckEntity> ducks) {
        this.group = ducks;
    }

    public AbstractDuckEntity getLeader() {
        return this.leader;
    }

    public void setLeader(AbstractDuckEntity leader) {
        this.leader = leader;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public static boolean registerSpawning(EntityType<AbstractDuckEntity> duck, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block block = world.func_180495_p(pos).func_177230_c();
        return blockDown.func_203417_a(BlockTags.field_203436_u) || blockDown instanceof GrassBlock || block == Blocks.field_150355_j || blockDown == Blocks.field_150355_j;
    }

    public static boolean checkIfContains(ItemStack[] stacks, Item i) {
        for (ItemStack stack : stacks) {
            if (stack.func_77973_b() != i) continue;
            return true;
        }
        return false;
    }

    public static class DuckAvoidEntityGoal
    extends AvoidEntityGoal {
        public DuckAvoidEntityGoal(CreatureEntity entityIn, Class classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super(entityIn, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
        }

        public DuckAvoidEntityGoal(CreatureEntity entityIn, Class avoidClass, Predicate targetPredicate, float distance, double nearSpeedIn, double farSpeedIn, Predicate p_i48859_9_) {
            super(entityIn, avoidClass, targetPredicate, distance, nearSpeedIn, farSpeedIn, p_i48859_9_);
        }

        public DuckAvoidEntityGoal(CreatureEntity p_i48860_1_, Class p_i48860_2_, float p_i48860_3_, double p_i48860_4_, double p_i48860_6_, Predicate p_i48860_8_) {
            super(p_i48860_1_, p_i48860_2_, p_i48860_3_, p_i48860_4_, p_i48860_6_, p_i48860_8_);
        }

        public boolean func_75250_a() {
            Main.LOGGER.debug("avoiding player");
            if (this.field_75380_a instanceof AbstractDuckEntity && ((AbstractDuckEntity)this.field_75380_a).breed) {
                Main.LOGGER.debug("false");
                return false;
            }
            if (super.func_75250_a() && this.field_75380_a instanceof AbstractDuckEntity) {
                ((AbstractDuckEntity)this.field_75380_a).setFlying(true);
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!super.func_75253_b() && this.field_75380_a instanceof AbstractDuckEntity) {
                ((AbstractDuckEntity)this.field_75380_a).setFlying(false);
            }
            return true;
        }
    }
}

