/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.items;

import com.matez.wildnature.common.items.recipes.cooking.CookingToolType;
import com.matez.wildnature.common.items.recipes.cooking.FillTool;
import com.matez.wildnature.common.items.recipes.cooking.WNAbstractCookingRecipe;
import com.matez.wildnature.init.Main;
import com.matez.wildnature.util.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CookingItem
extends Item {
    private CookingToolType toolType;
    private int clickCount = 0;

    public CookingItem(Item.Properties p_i48487_1_, CookingToolType toolType) {
        super(p_i48487_1_);
        this.toolType = toolType;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ArrayList<ItemStack> items = Utilities.loadItems(stack.func_196082_o());
        int i = 0;
        int j = 0;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("cooked") && nbt.func_74767_n("cooked")) {
            ItemStack result = Utilities.loadItem(nbt);
            if (result != null && !result.func_190926_b()) {
                String fill;
                Item fillItem;
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Cooked " + TextFormatting.YELLOW + result.func_200301_q().func_150254_d() + " x" + result.func_190916_E()));
                if (nbt.func_74764_b("fill") && (fillItem = CookingItem.getFillItem(fill = nbt.func_74779_i("fill"))) != null) {
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "Filling " + fillItem.func_200295_i(new ItemStack((IItemProvider)fillItem, 1)).func_150254_d()));
                }
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Right click to get it"));
            }
        } else {
            if (worldIn != null) {
                WNAbstractCookingRecipe recipe = CookingItem.checkForRecipes(worldIn, items, this.getToolType());
                if (recipe != null) {
                    ItemStack output = recipe.func_77571_b();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Cook now to get " + TextFormatting.YELLOW + output.func_200301_q().func_150254_d() + " x" + output.func_190916_E()));
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Cannot get recipes for this world"));
            }
            for (ItemStack itemstack : items) {
                if (itemstack.func_190926_b()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                ITextComponent itextcomponent = itemstack.func_200301_q().func_212638_h().func_211708_a(TextFormatting.DARK_GREEN);
                ITextComponent itextcomponent2 = new StringTextComponent("").func_150258_a(" x").func_150258_a(String.valueOf(itemstack.func_190916_E())).func_211708_a(TextFormatting.GRAY);
                tooltip.add(itextcomponent.func_150257_a(itextcomponent2));
            }
            if (j - i > 0) {
                tooltip.add(new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_211708_a(TextFormatting.GRAY).func_211708_a(TextFormatting.ITALIC));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        super.func_77659_a(world, player, hand);
        ItemStack stack = player.func_184586_b(hand);
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("cooked") && nbt.func_74767_n("cooked")) {
            ItemStack result = Utilities.loadItem(nbt);
            if (result != null && !result.func_190926_b()) {
                if (nbt.func_74764_b("fill")) {
                    ItemStack need = new ItemStack((IItemProvider)CookingItem.getFillItem(nbt.func_74779_i("fill")), result.func_190916_E());
                    boolean success = false;
                    if (need.func_190926_b() || need == null) {
                        success = true;
                        player.func_191521_c(result);
                    }
                    if (!success) {
                        for (int a = 0; a < result.func_190916_E(); ++a) {
                            for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                                ItemStack slot = player.field_71071_by.func_70301_a(x);
                                if (!slot.func_77969_a(need)) continue;
                                player.func_191521_c(new ItemStack((IItemProvider)result.func_77973_b(), 1));
                                slot.func_190920_e(slot.func_190916_E() - 1);
                                player.field_71071_by.func_70299_a(x, slot);
                                need.func_190920_e(need.func_190916_E() - 1);
                                nbt.func_82580_o("fill");
                                success = true;
                            }
                        }
                    }
                    if (!success) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                } else {
                    player.func_191521_c(result);
                }
                nbt.func_82580_o("cooked");
                stack.func_77982_d(new CompoundNBT());
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        } else {
            ArrayList<ItemStack> items = Utilities.loadItems(nbt);
            if (items.isEmpty()) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            ArrayList<ItemStack> itemsLeft = new ArrayList<ItemStack>();
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>();
            if (nbt.func_74764_b("Items")) {
                nbt.func_82580_o("Items");
            }
            if (nbt.func_74764_b("Slot")) {
                nbt.func_82580_o("Slot");
            }
            for (ItemStack itemStack2 : items) {
                Item i = itemStack2.func_77973_b();
                if (i.getRegistryName() == Items.field_151117_aB.getRegistryName()) {
                    itemsLeft.add(itemStack2);
                    ItemStack need = new ItemStack((IItemProvider)Items.field_151133_ar, itemStack2.func_190916_E());
                    for (int a = 0; a < itemStack2.func_190916_E(); ++a) {
                        for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                            ItemStack slot = player.field_71071_by.func_70301_a(x);
                            if (!slot.func_77969_a(need)) continue;
                            player.func_191521_c(new ItemStack((IItemProvider)itemStack2.func_77973_b(), 1));
                            slot.func_190920_e(slot.func_190916_E() - 1);
                            player.field_71071_by.func_70299_a(x, slot);
                            need.func_190920_e(need.func_190916_E() - 1);
                        }
                    }
                    if (!need.func_190926_b()) {
                        needed.add(need);
                        continue;
                    }
                    itemsLeft.remove(itemStack2);
                    continue;
                }
                player.func_191521_c(itemStack2);
            }
            if (!itemsLeft.isEmpty() && !needed.isEmpty()) {
                String[] s = new String[]{""};
                needed.forEach(itemStack -> {
                    s[0] = s[0] + itemStack.func_200301_q().func_150254_d() + " x" + itemStack.func_190916_E() + ",";
                });
                s[0] = s[0].substring(0, s[0].length() - 1);
                String[] s2 = new String[]{""};
                itemsLeft.forEach(itemStack -> {
                    s2[0] = s2[0] + itemStack.func_200301_q().func_150254_d() + " x" + itemStack.func_190916_E() + ",";
                });
                s2[0] = s2[0].substring(0, s2[0].length() - 1);
                if (this.clickCount == 0) {
                    ITextComponent t = new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150258_a(TextFormatting.RED + "You need " + TextFormatting.GOLD + s[0] + TextFormatting.RED + " in your inventory to take out " + TextFormatting.GOLD + s2[0]);
                    Utilities.saveItems(nbt, itemsLeft);
                    Main.sendChatMessage(player, t);
                }
            }
            stack.func_77982_d(nbt);
            ++this.clickCount;
            if (this.clickCount == 2) {
                this.clickCount = 0;
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public CookingToolType getToolType() {
        return this.toolType;
    }

    public static Item getFillItem(String fill) {
        for (FillTool value : FillTool.values()) {
            if (!value.func_176610_l().equals(fill)) continue;
            return value.getItem();
        }
        return null;
    }

    public static WNAbstractCookingRecipe checkForRecipes(World world, ArrayList<ItemStack> items, CookingToolType type) {
        ItemStack[] itemStacks = new ItemStack[items.size()];
        items.toArray(itemStacks);
        Inventory i = new Inventory(itemStacks);
        WNAbstractCookingRecipe recipe = world.func_199532_z().func_215371_a((IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("wildnature:cooking")), (IInventory)i, world).orElse(null);
        assert (recipe != null && recipe.func_77571_b() != null);
        try {
            if (!CookingItem.getGroupParams(recipe.func_193358_e())[0].equals(type.func_176610_l())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return recipe;
    }

    public static String[] getGroupParams(String group) {
        String[] s = new String[2];
        try {
            s[0] = group.split(";")[0];
            if (s[0].isEmpty()) {
                throw new NullPointerException("Null tool type");
            }
            s[1] = group.split(";")[1];
            if (s[1].isEmpty()) {
                s[1] = "none";
            }
        }
        catch (Exception e) {
            s[0] = group;
            s[1] = "none";
        }
        return s;
    }
}

