/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.items;

import com.matez.wildnature.util.other.Utilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GiftItem
extends Item {
    private GiftColor color;

    public GiftItem(Item.Properties properties, GiftColor color) {
        super(properties.func_200917_a(1));
        this.color = color;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack i = context.func_195999_j().func_184586_b(context.func_221531_n());
        ItemStack gift = Utilities.loadItem(i.func_77978_p());
        if (gift.func_190926_b()) {
            return ActionResultType.PASS;
        }
        context.func_195999_j().func_184611_a(context.func_221531_n(), gift);
        context.func_195991_k().func_184133_a(context.func_195999_j(), context.func_195999_j().func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.MASTER, 0.8f, 1.1f);
        return ActionResultType.SUCCESS;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        ItemStack gift = Utilities.loadItem(stack.func_77978_p());
        if (!gift.func_190926_b() && !stack.func_196082_o().func_74764_b("owner")) {
            stack.func_196082_o().func_74778_a("owner", playerIn.func_145748_c_().func_150254_d());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        ItemStack gift = Utilities.loadItem(stack.func_77978_p());
        return !gift.func_190926_b();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_196082_o().func_74764_b("owner")) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "from " + TextFormatting.DARK_PURPLE + stack.func_196082_o().func_74779_i("owner")));
        } else {
            if (this.color == GiftColor.CYAN_RED) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"color.minecraft.cyan", (Object[])new Object[0]) + TextFormatting.GRAY + " & " + TextFormatting.RED + I18n.func_135052_a((String)"color.minecraft.red", (Object[])new Object[0])));
            }
            if (this.color == GiftColor.RED_YELLOW) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"color.minecraft.red", (Object[])new Object[0]) + TextFormatting.GRAY + " & " + TextFormatting.YELLOW + I18n.func_135052_a((String)"color.minecraft.yellow", (Object[])new Object[0])));
            }
            if (this.color == GiftColor.BLUE_PINK) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_BLUE + I18n.func_135052_a((String)"color.minecraft.blue", (Object[])new Object[0]) + TextFormatting.GRAY + " & " + TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"color.minecraft.pink", (Object[])new Object[0])));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static enum GiftColor implements IStringSerializable
    {
        CYAN_RED("cyan_red"),
        RED_YELLOW("red_yellow"),
        BLUE_PINK("blue_pink");

        public static final GiftColor[] VALUES;
        private final String name;

        private GiftColor(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return null;
        }

        static {
            VALUES = GiftColor.values();
        }
    }
}

