/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.common.items.recipes.cooking;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.matez.wildnature.common.items.recipes.cooking.WNAbstractCookingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WNCookingRecipeSerializer<T extends WNAbstractCookingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final int field_222178_t;
    private final IFactory<T> factory;

    public WNCookingRecipeSerializer(IFactory<T> factory, int p_i50025_2_) {
        this.field_222178_t = p_i50025_2_;
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.field_222178_t);
        return this.factory.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack itemstack = buffer.func_150791_c();
        float f = buffer.readFloat();
        int i = buffer.func_150792_a();
        return this.factory.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((WNAbstractCookingRecipe)recipe).group);
        ((WNAbstractCookingRecipe)recipe).ingredient.func_199564_a(buffer);
        buffer.func_150788_a(((WNAbstractCookingRecipe)recipe).result);
        buffer.writeFloat(((WNAbstractCookingRecipe)recipe).experience);
        buffer.func_150787_b(((WNAbstractCookingRecipe)recipe).cookTime);
    }

    public static interface IFactory<T extends WNAbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

