/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.other;

import java.util.ArrayList;
import net.minecraft.block.BlockState;

public class BlockWeighList {
    protected ArrayList<BlockState> blocks = new ArrayList();
    protected ArrayList<Integer> weigh = new ArrayList();

    public ArrayList<BlockState> getNormalArrayList() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (int x = 0; x < this.size(); ++x) {
            int a = this.getWeighList().get(x);
            for (int z = 0; z < a; ++z) {
                states.add(this.getBlockList().get(x));
            }
        }
        return states;
    }

    public static BlockWeighList parseFromNormalArrayList(ArrayList<BlockState> states) {
        BlockWeighList list = new BlockWeighList();
        for (BlockState state : states) {
            if (!list.getBlockList().contains(state)) continue;
            int oldRarity = list.getRarityFor(state);
            list.remove(state);
            list.add(state, oldRarity + 1);
        }
        return list;
    }

    public void add(BlockState block, Integer iWeigh) {
        this.blocks.add(block);
        this.weigh.add(iWeigh);
    }

    public void remove(BlockState block, Integer iWeigh) {
        this.blocks.remove(block);
        this.weigh.remove(iWeigh);
    }

    public void remove(BlockState block) {
        this.weigh.remove(this.weigh.get(this.blocks.indexOf(block)));
        this.blocks.remove(block);
    }

    public int getRarityFor(BlockState block) {
        return this.weigh.get(this.blocks.indexOf(block));
    }

    public void clear() {
        this.weigh.clear();
        this.blocks.clear();
    }

    public Integer size() {
        if (this.checkIfEquals()) {
            return this.blocks.size();
        }
        return -99999;
    }

    public boolean checkIfEquals() {
        return this.blocks.size() == this.weigh.size();
    }

    public ArrayList<Integer> getWeighList() {
        return this.weigh;
    }

    public ArrayList<BlockState> getBlockList() {
        return this.blocks;
    }
}

