/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.util.other;

import com.google.common.collect.Lists;
import com.matez.wildnature.common.blocks.CustomPistonBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CustomPistonBlockStructureHelper {
    private final World world;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos blockToMove;
    private final Direction moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final Direction facing;

    public CustomPistonBlockStructureHelper(World worldIn, BlockPos posIn, Direction pistonFacing, boolean extending) {
        this.world = worldIn;
        this.pistonPos = posIn;
        this.facing = pistonFacing;
        this.extending = extending;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = posIn.func_177972_a(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.func_176734_d();
            this.blockToMove = posIn.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean canMove() {
        this.toMove.clear();
        this.toDestroy.clear();
        BlockState blockstate = this.world.func_180495_p(this.blockToMove);
        if (!CustomPistonBlock.canPush(blockstate, this.world, this.blockToMove, this.moveDirection, false, this.facing)) {
            if (this.extending && blockstate.func_185905_o() == PushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos blockpos = this.toMove.get(i);
            if (!this.world.func_180495_p(blockpos).isStickyBlock() || this.addBranchingBlocks(blockpos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, Direction facingIn) {
        BlockPos blockpos;
        BlockState blockstate = this.world.func_180495_p(origin);
        if (this.world.func_175623_d(origin)) {
            return true;
        }
        if (!CustomPistonBlock.canPush(blockstate, this.world, origin, this.moveDirection, false, facingIn)) {
            return true;
        }
        if (origin.equals((Object)this.pistonPos)) {
            return true;
        }
        if (this.toMove.contains(origin)) {
            return true;
        }
        int i = 1;
        if (i + this.toMove.size() > 12) {
            return false;
        }
        while (blockstate.isStickyBlock() && !(blockstate = this.world.func_180495_p(blockpos = origin.func_177967_a(this.moveDirection.func_176734_d(), i))).isAir((IBlockReader)this.world, blockpos) && CustomPistonBlock.canPush(blockstate, this.world, blockpos, this.moveDirection, false, this.moveDirection.func_176734_d()) && !blockpos.equals((Object)this.pistonPos)) {
            if (++i + this.toMove.size() <= 12) continue;
            return false;
        }
        int i1 = 0;
        for (int j = i - 1; j >= 0; --j) {
            this.toMove.add(origin.func_177967_a(this.moveDirection.func_176734_d(), j));
            ++i1;
        }
        int j1 = 1;
        while (true) {
            BlockPos blockpos1;
            int k;
            if ((k = this.toMove.indexOf(blockpos1 = origin.func_177967_a(this.moveDirection, j1))) > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos blockpos2 = this.toMove.get(l);
                    if (!this.world.func_180495_p(blockpos2).isStickyBlock() || this.addBranchingBlocks(blockpos2)) continue;
                    return false;
                }
                return true;
            }
            blockstate = this.world.func_180495_p(blockpos1);
            if (blockstate.isAir((IBlockReader)this.world, blockpos1)) {
                return true;
            }
            if (!CustomPistonBlock.canPush(blockstate, this.world, blockpos1, this.moveDirection, true, this.moveDirection) || blockpos1.equals((Object)this.pistonPos)) {
                return false;
            }
            if (blockstate.func_185905_o() == PushReaction.DESTROY) {
                this.toDestroy.add(blockpos1);
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(blockpos1);
            ++i1;
            ++j1;
        }
    }

    private void reorderListAtCollision(int p_177255_1_, int p_177255_2_) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, p_177255_2_));
        list1.addAll(this.toMove.subList(this.toMove.size() - p_177255_1_, this.toMove.size()));
        list2.addAll(this.toMove.subList(p_177255_2_, this.toMove.size() - p_177255_1_));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos fromPos) {
        for (Direction direction : Direction.values()) {
            if (direction.func_176740_k() == this.moveDirection.func_176740_k() || this.addBlockLine(fromPos.func_177972_a(direction), direction)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getBlocksToMove() {
        return this.toMove;
    }

    public List<BlockPos> getBlocksToDestroy() {
        return this.toDestroy;
    }
}

