/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.biomes;

import com.matez.wildnature.common.blocks.FloweringBushBase;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.world.generation.biome.setup.LogType;
import com.matez.wildnature.world.generation.biome.setup.WNBiome;
import com.matez.wildnature.world.generation.biome.setup.WNBiomeBuilder;
import com.matez.wildnature.world.generation.biome.setup.WNBiomeFeatures;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.citrus3;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.citrus4;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.olive1;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.olive2;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.olive3;
import com.matez.wildnature.world.generation.structures.nature.woods.citrus.olive4;
import com.matez.wildnature.world.generation.structures.nature.woods.shrubs.shrub1;
import com.matez.wildnature.world.generation.surface.SurfaceRegistry;
import com.matez.wildnature.world.generation.surface.builders.CustomSurfaceBuilder;
import com.matez.wildnature.world.generation.surface.configs.CustomSurfaceBuilderConfig;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WNOliveHills
extends WNBiome {
    public WNOliveHills(String name) {
        super(name, new WNBiomeBuilder().surfaceBuilder(SurfaceRegistry.CUSTOM_SURFACE_BUILDER, new CustomSurfaceBuilderConfig(new CustomSurfaceBuilder.BlockCfg(SurfaceRegistry.OVERGROWN_STONE_CONFIG, 10), new CustomSurfaceBuilder.BlockCfg(SurfaceBuilder.field_215423_t, 1))).precipitation(Biome.RainType.RAIN).category(Biome.Category.FOREST).topography(WNBiomeBuilder.Topography.LOWLANDS).climate(WNBiomeBuilder.Climate.CONTINENTAL_WARM).depth(1.1f).scale(0.75f).temperature(0.7f).downfall(0.8f).waterColor(4159204).waterFogColor(329011).logTypes(LogType.OLIVE, LogType.GRAPEFRUIT).parent(null));
        WNBiomeFeatures.addMineshafts(this, MineshaftStructure.Type.NORMAL);
        WNBiomeFeatures.addStrongholds(this);
        WNBiomeFeatures.addCarvers(this);
        WNBiomeFeatures.func_222295_c((Biome)this);
        WNBiomeFeatures.addLakes(this);
        WNBiomeFeatures.func_222335_f((Biome)this);
        WNBiomeFeatures.func_222338_N((Biome)this);
        WNBiomeFeatures.func_222326_g((Biome)this);
        WNBiomeFeatures.func_222288_h((Biome)this);
        WNBiomeFeatures.func_222282_l((Biome)this);
        WNBiomeFeatures.addGrass(this);
        WNBiomeFeatures.func_222311_aa((Biome)this);
        WNBiomeFeatures.addSprings(this);
        WNBiomeFeatures.addPlant(this, (BlockState)WNBlocks.CANA_BULB_ORANGE.func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 3);
        WNBiomeFeatures.addPlant(this, (BlockState)WNBlocks.CANA_BULB_RED.func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
        WNBiomeFeatures.addPlant(this, (BlockState)WNBlocks.CANA_BULB_PINK.func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
        WNBiomeFeatures.addPlant(this, (BlockState)WNBlocks.CANA_BULB_YELLOW.func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 3);
        WNBiomeFeatures.addPlant(this, WNBlocks.YEW_BUSH.func_176223_P(), 4);
        WNBiomeFeatures.addPlant(this, (BlockState)WNBlocks.PASQUE_WHITE.func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
        WNBiomeFeatures.addPlant(this, WNBlocks.CLOVER.func_176223_P(), 3);
        WNBiomeFeatures.addPlant(this, WNBlocks.LEAF_PILE.func_176223_P(), 3);
        WNBiomeFeatures.addTree(this, new olive1(), 3);
        WNBiomeFeatures.addTree(this, new olive2(), 3);
        WNBiomeFeatures.addTree(this, new olive3(), 3);
        WNBiomeFeatures.addTree(this, new olive4(), 3);
        WNBiomeFeatures.addTree(this, new shrub1(), 6);
        WNBiomeFeatures.addTree(this, new citrus3().setCustomLog(WNBlocks.CITRUS_LOG.func_176223_P()).setCustomLeaf(SchemFeature.notDecayingLeaf(WNBlocks.GRAPE_FRUIT_LEAVES)), 1);
        WNBiomeFeatures.addTree(this, new citrus4().setCustomLog(WNBlocks.CITRUS_LOG.func_176223_P()).setCustomLeaf(SchemFeature.notDecayingLeaf(WNBlocks.GRAPE_FRUIT_LEAVES)), 1);
        this.treeRate = 7;
        this.applyPlants();
        this.applyTrees();
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200737_ac, 12, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200795_i, 3, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200796_j, 1, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200724_aC, 1, 4, 4));
        this.func_201866_a(EntityClassification.AMBIENT, new Biome.SpawnListEntry(EntityType.field_200791_e, 10, 8, 8));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200748_an, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200725_aD, 45, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200763_C, 35, 1, 3));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200727_aF, 5, 1, 1));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200741_ag, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200797_k, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200743_ai, 100, 4, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200803_q, 10, 1, 4));
        this.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry(EntityType.field_200759_ay, 5, 1, 1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getGrassColor(BlockPos pos) {
        double noise = field_180281_af.func_215464_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225, false);
        return this.customColor(noise, -0.1, 10864402, 8827661);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getFoliageColor(BlockPos pos) {
        double noise = field_180281_af.func_215464_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225, false);
        return this.customColor(noise, -0.1, 8242176, 10276096);
    }
}

