/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.layer;

import com.matez.wildnature.world.generation.biome.setup.WNBiomes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum WNEdgeBiomeLayer implements ICastleTransformer
{
    INSTANCE;

    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int SNOWY_TUNDRA;
    private static final int JUNGLE;
    private static final int BAMBOO_JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int BADLANDS;
    private static final int BADLANDS_PLATEAU;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int PLAINS;
    private static final int GIANT_TREE_TAIGA;
    private static final int MOUNTAIN_EDGE;
    private static final int SWAMP;
    private static final int TAIGA;
    private static final int SNOWY_TAIGA;
    private static final int POLDERS;
    private static final int POLDERS_EDGE;
    private static final int TATRA_FOOTHILLS;
    private static final int TATRA_LOWER_FOREST;
    private static final int TATRA_UPPER_FOREST;
    private static final int TATRA_MOUNTAINS;
    private static final int TATRA_GREENED_PEAK;
    private static final int TATRA_RED_PEAK;
    private static final int TATRA_KASPROWY_PEAK;
    private static final int CHOCHOLOWSKA_GLADE;
    private static final int FIREWEED_VALLEY;
    private static final int CRACOW_GORGE;
    private static final int MORSKIE_OKO;
    private static final int GIEWONT;
    private static final int RYSY;
    private static final int SNOWY_TATRA_FOOTHILLS;
    private static final int SNOWY_TATRA_LOWER_FOREST;
    private static final int SNOWY_TATRA_UPPER_FOREST;
    private static final int SNOWY_TATRA_MOUNTAINS;
    private static final int SNOWY_TATRA_KASPROWY_PEAK;
    private static final int SNOWY_CHOCHOLOWSKA_GLADE;
    private static final int SNOWY_FIREWEED_VALLEY;
    private static final int SNOWY_CRACOW_GORGE;
    private static final int FROZEN_MORSKIE_OKO;
    private static final int SNOWY_GIEWONT;

    private static boolean isTatra(int biomeNear) {
        return biomeNear == TATRA_LOWER_FOREST || biomeNear == TATRA_UPPER_FOREST || biomeNear == TATRA_MOUNTAINS || biomeNear == TATRA_GREENED_PEAK || biomeNear == TATRA_RED_PEAK || biomeNear == TATRA_KASPROWY_PEAK || biomeNear == CHOCHOLOWSKA_GLADE || biomeNear == FIREWEED_VALLEY || biomeNear == CRACOW_GORGE || biomeNear == MORSKIE_OKO || biomeNear == GIEWONT || biomeNear == RYSY;
    }

    private static boolean isSnowyTatra(int biomeNear) {
        return biomeNear == SNOWY_TATRA_LOWER_FOREST || biomeNear == SNOWY_TATRA_UPPER_FOREST || biomeNear == SNOWY_TATRA_MOUNTAINS || biomeNear == SNOWY_TATRA_KASPROWY_PEAK || biomeNear == SNOWY_CHOCHOLOWSKA_GLADE || biomeNear == SNOWY_FIREWEED_VALLEY || biomeNear == SNOWY_CRACOW_GORGE || biomeNear == FROZEN_MORSKIE_OKO || biomeNear == SNOWY_GIEWONT || biomeNear == RYSY;
    }

    public int func_202748_a(INoiseRandom context, int north, int west, int south, int east, int center) {
        int[] aint = new int[1];
        if (!(this.func_202751_a(aint, north, west, south, east, center, MOUNTAINS, MOUNTAIN_EDGE) || this.replaceBiomeEdge(aint, north, west, south, east, center, WOODED_BADLANDS_PLATEAU, BADLANDS) || this.replaceBiomeEdge(aint, north, west, south, east, center, BADLANDS_PLATEAU, BADLANDS) || this.replaceBiomeEdge(aint, north, west, south, east, center, GIANT_TREE_TAIGA, TAIGA))) {
            if (center != DESERT || north != SNOWY_TUNDRA && west != SNOWY_TUNDRA && east != SNOWY_TUNDRA && south != SNOWY_TUNDRA) {
                if (center == SWAMP) {
                    if (north == DESERT || west == DESERT || east == DESERT || south == DESERT || north == SNOWY_TAIGA || west == SNOWY_TAIGA || east == SNOWY_TAIGA || south == SNOWY_TAIGA || north == SNOWY_TUNDRA || west == SNOWY_TUNDRA || east == SNOWY_TUNDRA || south == SNOWY_TUNDRA) {
                        return PLAINS;
                    }
                    if (north == JUNGLE || south == JUNGLE || west == JUNGLE || east == JUNGLE || north == BAMBOO_JUNGLE || south == BAMBOO_JUNGLE || west == BAMBOO_JUNGLE || east == BAMBOO_JUNGLE) {
                        return JUNGLE_EDGE;
                    }
                    if (north == POLDERS || south == POLDERS || west == POLDERS || east == POLDERS) {
                        return POLDERS_EDGE;
                    }
                    if (WNEdgeBiomeLayer.isTatra(north) || WNEdgeBiomeLayer.isTatra(south) || WNEdgeBiomeLayer.isTatra(east) || WNEdgeBiomeLayer.isTatra(west)) {
                        return TATRA_FOOTHILLS;
                    }
                    if (WNEdgeBiomeLayer.isSnowyTatra(north) || WNEdgeBiomeLayer.isSnowyTatra(south) || WNEdgeBiomeLayer.isSnowyTatra(east) || WNEdgeBiomeLayer.isSnowyTatra(west)) {
                        return SNOWY_TATRA_FOOTHILLS;
                    }
                }
                return center;
            }
            if (north == POLDERS || south == POLDERS || west == POLDERS || east == POLDERS) {
                return POLDERS_EDGE;
            }
            if (WNEdgeBiomeLayer.isSnowyTatra(north) || WNEdgeBiomeLayer.isSnowyTatra(south) || WNEdgeBiomeLayer.isSnowyTatra(east) || WNEdgeBiomeLayer.isSnowyTatra(west)) {
                return SNOWY_TATRA_FOOTHILLS;
            }
            return WOODED_MOUNTAINS;
        }
        return aint[0];
    }

    private boolean func_202751_a(int[] p_202751_1_, int p_202751_2_, int p_202751_3_, int p_202751_4_, int p_202751_5_, int p_202751_6_, int p_202751_7_, int p_202751_8_) {
        if (!LayerUtil.func_202826_a((int)p_202751_6_, (int)p_202751_7_)) {
            return false;
        }
        p_202751_1_[0] = this.canBiomesBeNeighbors(p_202751_2_, p_202751_7_) && this.canBiomesBeNeighbors(p_202751_3_, p_202751_7_) && this.canBiomesBeNeighbors(p_202751_5_, p_202751_7_) && this.canBiomesBeNeighbors(p_202751_4_, p_202751_7_) ? p_202751_6_ : p_202751_8_;
        return true;
    }

    private boolean replaceBiomeEdge(int[] p_151635_1_, int p_151635_2_, int p_151635_3_, int p_151635_4_, int p_151635_5_, int p_151635_6_, int p_151635_7_, int p_151635_8_) {
        if (p_151635_6_ != p_151635_7_) {
            return false;
        }
        p_151635_1_[0] = LayerUtil.func_202826_a((int)p_151635_2_, (int)p_151635_7_) && LayerUtil.func_202826_a((int)p_151635_3_, (int)p_151635_7_) && LayerUtil.func_202826_a((int)p_151635_5_, (int)p_151635_7_) && LayerUtil.func_202826_a((int)p_151635_4_, (int)p_151635_7_) ? p_151635_6_ : p_151635_8_;
        return true;
    }

    private boolean canBiomesBeNeighbors(int p_151634_1_, int p_151634_2_) {
        if (LayerUtil.func_202826_a((int)p_151634_1_, (int)p_151634_2_)) {
            return true;
        }
        Biome biome = (Biome)Registry.field_212624_m.func_148745_a(p_151634_1_);
        Biome biome1 = (Biome)Registry.field_212624_m.func_148745_a(p_151634_2_);
        if (biome != null && biome1 != null) {
            Biome.TempCategory biome$tempcategory1;
            Biome.TempCategory biome$tempcategory = biome.func_150561_m();
            return biome$tempcategory == (biome$tempcategory1 = biome1.func_150561_m()) || biome$tempcategory == Biome.TempCategory.MEDIUM || biome$tempcategory1 == Biome.TempCategory.MEDIUM;
        }
        return false;
    }

    static {
        DESERT = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
        MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
        WOODED_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150580_W);
        SNOWY_TUNDRA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76774_n);
        JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
        BAMBOO_JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_222370_aw);
        JUNGLE_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150574_L);
        BADLANDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150589_Z);
        BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
        WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
        PLAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76772_c);
        GIANT_TREE_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150578_U);
        MOUNTAIN_EDGE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76783_v);
        SWAMP = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
        TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
        SNOWY_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150584_S);
        POLDERS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Polders);
        POLDERS_EDGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.PoldersEdge);
        TATRA_FOOTHILLS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraFoothills);
        TATRA_LOWER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraLowerForest);
        TATRA_UPPER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraUpperForest);
        TATRA_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraMountains);
        TATRA_GREENED_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraGreenedPeak);
        TATRA_RED_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraRedPeak);
        TATRA_KASPROWY_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TatraKasprowyPeak);
        CHOCHOLOWSKA_GLADE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.ChocholowskaGlade);
        FIREWEED_VALLEY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.FireweedValley);
        CRACOW_GORGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.CracowGorge);
        MORSKIE_OKO = Registry.field_212624_m.func_148757_b((Object)WNBiomes.MorskieOko);
        GIEWONT = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Giewont);
        RYSY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Rysy);
        SNOWY_TATRA_FOOTHILLS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraFoothills);
        SNOWY_TATRA_LOWER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraLowerForest);
        SNOWY_TATRA_UPPER_FOREST = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraUpperForest);
        SNOWY_TATRA_MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraMountains);
        SNOWY_TATRA_KASPROWY_PEAK = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyTatraKasprowyPeak);
        SNOWY_CHOCHOLOWSKA_GLADE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyChocholowskaGlade);
        SNOWY_FIREWEED_VALLEY = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyFireweedValley);
        SNOWY_CRACOW_GORGE = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyCracowGorge);
        FROZEN_MORSKIE_OKO = Registry.field_212624_m.func_148757_b((Object)WNBiomes.FrozenMorskieOko);
        SNOWY_GIEWONT = Registry.field_212624_m.func_148757_b((Object)WNBiomes.SnowyGiewont);
    }
}

