/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.biome.setup;

import com.matez.wildnature.world.generation.biome.setup.WNBiomes;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeVariants {
    private final SmallGroup smallGroup;
    private final LargeGroup largeGroup;
    public static BiomeVariants LAND = new BiomeVariants(SmallGroup.BODY, LargeGroup.LAND);
    public static BiomeVariants RIVER = new BiomeVariants(SmallGroup.BODY, LargeGroup.RIVER);
    public static BiomeVariants LAKE = new BiomeVariants(SmallGroup.BODY, LargeGroup.RIVER);
    public static BiomeVariants SHORE = new BiomeVariants(SmallGroup.BODY, LargeGroup.LAND);
    public static BiomeVariants OCEAN = new BiomeVariants(SmallGroup.BODY, LargeGroup.OCEAN);
    public static BiomeVariants PATH = new BiomeVariants(SmallGroup.RIVER, LargeGroup.RIVER);

    public BiomeVariants(SmallGroup smallGroup, LargeGroup largeGroup) {
        this.smallGroup = smallGroup;
        this.largeGroup = largeGroup;
    }

    public LargeGroup getLargeGroup() {
        return this.largeGroup;
    }

    public SmallGroup getSmallGroup() {
        return this.smallGroup;
    }

    public static BiomeVariants getVariantsFor(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return OCEAN;
        }
        if (biome == WNBiomes.ColdLake || biome == WNBiomes.DriedLake || biome == WNBiomes.FrozenLake || biome == WNBiomes.TropicalLake || biome == WNBiomes.WarmLake) {
            return LAKE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            return SHORE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            return RIVER;
        }
        return LAND;
    }

    public static BiomeVariants getVariantsFor(LerpConfiguration configuration) {
        return BiomeVariants.getVariantsFor(configuration.getBiome());
    }

    public static enum SmallGroup {
        BODY,
        RIVER;

        public static final int SIZE;

        static {
            SIZE = SmallGroup.values().length;
        }
    }

    public static enum LargeGroup {
        LAND,
        OCEAN,
        RIVER,
        LAKE;

        public static final int SIZE;

        static {
            SIZE = LargeGroup.values().length;
        }
    }
}

