/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.feature.features;

import com.matez.wildnature.common.blocks.BelladonnaBlock;
import com.matez.wildnature.common.blocks.BushBerryBase;
import com.matez.wildnature.common.blocks.CropBase;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.util.other.WeightedList;
import com.matez.wildnature.world.generation.feature.FeatureRegistry;
import com.matez.wildnature.world.generation.feature.configs.BlockFeatureConfig;
import com.matez.wildnature.world.generation.structures.nature.SchemFeature;
import com.matez.wildnature.world.generation.structures.nature.woods.shrubs.shrub1;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;

public class WNFruitFeature
extends Feature<NoFeatureConfig> {
    public static WeightedList<BushEntry> entries = new WeightedList();

    public WNFruitFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i49915_1_) {
        super(p_i49915_1_);
        this.setRegistryName("wildnature", "fruit_feature");
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!worldIn.func_201675_m().func_76569_d()) {
            return false;
        }
        if (Utilities.rint(0, (Integer)CommonConfig.fruitBushChance.get()) != 0) {
            return false;
        }
        WeightedList available = new WeightedList();
        entries.forEach(e -> {
            if (e.canSpawnHere(pos, worldIn)) {
                available.add(e, entries.getRarityFor((BushEntry)e));
            }
        });
        if (!available.isEmpty()) {
            BushEntry b = (BushEntry)Utilities.getWeightedEntry(available, rand);
            assert (b != null);
            if (!b.isPlant()) {
                new shrub1().setCustomLog(b.getBush()).setCustomLeaf((BlockState)SchemFeature.notDecayingLeaf(b.getBush().func_177230_c()).func_206870_a((IProperty)BushBerryBase.STAGE, (Comparable)Integer.valueOf(Utilities.rint(0, 1, rand)))).place(worldIn, generator, rand, pos, config);
            } else if (b.getBush().func_177230_c() instanceof BelladonnaBlock) {
                FeatureRegistry.BUSH_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockFeatureConfig(b.getBush()));
            } else {
                FeatureRegistry.BUSH_FEATURE.func_212245_a(worldIn, generator, rand, pos, (IFeatureConfig)new BlockFeatureConfig((BlockState)b.getBush().func_206870_a((IProperty)((CropBase)b.getBush().func_177230_c()).getAge(), (Comparable)Integer.valueOf(Utilities.rint(((CropBase)b.getBush().func_177230_c()).func_185526_g() - 1, ((CropBase)b.getBush().func_177230_c()).func_185526_g())))));
            }
            return true;
        }
        return false;
    }

    public static void init() {
        new BushEntry(WNBlocks.BUSH_RASPBERRY.func_176223_P(), Biome.TempCategory.WARM, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_RASPBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 4, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLUEBERRY.func_176223_P(), Biome.TempCategory.WARM, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLUEBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 4, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLUEBERRY.func_176223_P(), Biome.TempCategory.COLD, 2, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_LINGONBERRY.func_176223_P(), Biome.TempCategory.COLD, 3, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_LINGONBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 1, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_GOOSEBERRY.func_176223_P(), Biome.TempCategory.WARM, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_GOOSEBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 3, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_CHOKEBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 6, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLACK_CURRANT.func_176223_P(), Biome.TempCategory.MEDIUM, 2, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_RED_CURRANT.func_176223_P(), Biome.TempCategory.MEDIUM, 2, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_WHITE_CURRANT.func_176223_P(), Biome.TempCategory.MEDIUM, 1, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_HAWTHORN.func_176223_P(), Biome.TempCategory.MEDIUM, 2, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_HAWTHORN.func_176223_P(), Biome.TempCategory.COLD, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_KAMCHATKA.func_176223_P(), Biome.TempCategory.COLD, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_WILD_STRAWBERRY.func_176223_P(), Biome.TempCategory.WARM, 5, true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BUSH_QUINCE.func_176223_P(), Biome.TempCategory.MEDIUM, 2, true, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BUSH_BILBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 5, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLACK_LILAC.func_176223_P(), Biome.TempCategory.MEDIUM, 4, true, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BUSH_BLACK_LILAC.func_176223_P(), Biome.TempCategory.MEDIUM, 4, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_BLACKBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 6, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_CRANBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 4, true, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BUSH_CRANBERRY.func_176223_P(), Biome.TempCategory.COLD, 4, true, BiomeDictionary.Type.PLAINS);
        new BushEntry(WNBlocks.BUSH_WILD_BLUEBERRY.func_176223_P(), Biome.TempCategory.COLD, 2, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_WILD_BLUEBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 4, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BUSH_WILD_BLUEBERRY.func_176223_P(), Biome.TempCategory.COLD, 4, true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        new BushEntry(WNBlocks.BUSH_WILD_BLUEBERRY.func_176223_P(), Biome.TempCategory.MEDIUM, 8, true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        new BushEntry(WNBlocks.BELLADONNA.func_176223_P(), Biome.TempCategory.COLD, 3, true, BiomeDictionary.Type.FOREST);
        new BushEntry(WNBlocks.BELLADONNA.func_176223_P(), Biome.TempCategory.MEDIUM, 2, true, BiomeDictionary.Type.FOREST);
    }

    public static class BushEntry {
        private BlockState bush;
        private Biome.TempCategory category;
        private BiomeDictionary.Type[] types;
        private int rarity;
        private boolean plant = false;

        public BushEntry(BlockState bush, Biome.TempCategory tempCategory, int rarity, BiomeDictionary.Type ... types) {
            this.bush = bush;
            this.category = tempCategory;
            this.types = types;
            this.rarity = rarity;
            entries.add(this, rarity);
        }

        public BushEntry(BlockState bush, Biome.TempCategory tempCategory, int rarity, boolean plant, BiomeDictionary.Type ... types) {
            this.bush = bush;
            this.category = tempCategory;
            this.types = types;
            this.rarity = rarity;
            this.plant = plant;
            entries.add(this, rarity);
        }

        public int getRarity() {
            return this.rarity;
        }

        public BlockState getBush() {
            return this.bush;
        }

        public boolean isPlant() {
            return this.plant;
        }

        public Biome.TempCategory getCategory() {
            return this.category;
        }

        public BiomeDictionary.Type[] getTypes() {
            return this.types;
        }

        public boolean canSpawnHere(BlockPos pos, IWorld world) {
            Biome b = world.func_226691_t_(pos);
            if (this.getTempCategory(b) == this.category) {
                for (BiomeDictionary.Type t : this.types) {
                    if (!BiomeDictionary.getTypes((Biome)b).contains(t)) continue;
                    return true;
                }
            }
            return false;
        }

        public Biome.TempCategory getTempCategory(Biome b) {
            if (b.func_201856_r() == Biome.Category.OCEAN) {
                return Biome.TempCategory.OCEAN;
            }
            if ((double)b.func_185353_n() < 0.2) {
                return Biome.TempCategory.COLD;
            }
            return (double)b.func_185353_n() < 0.5 ? Biome.TempCategory.MEDIUM : Biome.TempCategory.WARM;
        }
    }
}

