/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.carves;

import com.matez.wildnature.common.commands.LocatePath;
import com.matez.wildnature.util.config.CommonConfig;
import com.matez.wildnature.util.lists.WNBlocks;
import com.matez.wildnature.util.other.Utilities;
import com.matez.wildnature.world.generation.noise.OpenSimplex2S;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.BiomeDictionary;

public class PathGenerator {
    private final OpenSimplex2S pathNoise;

    public PathGenerator(IWorld worldIn) {
        this.pathNoise = new OpenSimplex2S(worldIn.func_72905_C());
    }

    public void generate(int x, int y, int z, Biome biome, IChunk chunkIn) {
        double[] pathNoises;
        if (((Boolean)CommonConfig.generatePaths.get()).booleanValue() && this.isPath(pathNoises = this.applyPathNoise(x, z)) && BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) && BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.DENSE)) {
            int pathY = y;
            Block theme = biome.func_203944_q().func_204108_a().func_177230_c();
            BlockState b = chunkIn.func_180495_p(new BlockPos(x, y - 1, z));
            Block toPlace = null;
            if (b.func_177230_c() == WNBlocks.MOLD_GRASS_BLOCK) {
                toPlace = WNBlocks.MOLD_GRASS_PATH;
            } else if (b.func_177230_c() == WNBlocks.BROWN_GRASS_BLOCK) {
                toPlace = WNBlocks.BROWN_GRASS_PATH;
            } else if (b.func_177230_c() == WNBlocks.DRIED_GRASS_BLOCK) {
                toPlace = WNBlocks.DRIED_GRASS_PATH;
            } else if (b.func_177230_c() == WNBlocks.DESERT_GRASS_BLOCK) {
                toPlace = WNBlocks.DESERT_GRASS_PATH;
            } else if (b.func_177230_c() == WNBlocks.TROPICAL_GRASS_BLOCK) {
                toPlace = WNBlocks.TROPICAL_GRASS_PATH;
            } else if (b.func_177230_c() == WNBlocks.BROWN_PODZOL) {
                toPlace = WNBlocks.BROWN_GRASS_PATH;
            } else if (b.func_177230_c() == Blocks.field_196658_i) {
                toPlace = Blocks.field_185774_da;
            } else if (b.func_177230_c() == Blocks.field_196661_l) {
                toPlace = theme == WNBlocks.MOLD_GRASS_BLOCK ? WNBlocks.MOLD_GRASS_PATH : (theme == WNBlocks.BROWN_GRASS_BLOCK ? WNBlocks.BROWN_GRASS_PATH : (theme == WNBlocks.DRIED_GRASS_BLOCK ? WNBlocks.DRIED_GRASS_PATH : (theme == WNBlocks.DESERT_GRASS_BLOCK ? WNBlocks.DESERT_GRASS_PATH : (theme == WNBlocks.TROPICAL_GRASS_BLOCK ? WNBlocks.TROPICAL_GRASS_PATH : (theme == WNBlocks.BROWN_PODZOL ? WNBlocks.BROWN_GRASS_PATH : Blocks.field_185774_da)))));
            } else if (b.func_177230_c() == Blocks.field_196660_k) {
                toPlace = theme == WNBlocks.MOLD_GRASS_BLOCK ? WNBlocks.MOLD_GRASS_PATH : (theme == WNBlocks.BROWN_GRASS_BLOCK ? WNBlocks.BROWN_GRASS_PATH : (theme == WNBlocks.DRIED_GRASS_BLOCK ? WNBlocks.DRIED_GRASS_PATH : (theme == WNBlocks.DESERT_GRASS_BLOCK ? WNBlocks.DESERT_GRASS_PATH : (theme == WNBlocks.TROPICAL_GRASS_BLOCK ? WNBlocks.TROPICAL_GRASS_PATH : (theme == WNBlocks.BROWN_PODZOL ? WNBlocks.BROWN_GRASS_PATH : Blocks.field_185774_da)))));
            }
            if (toPlace != null) {
                if (Utilities.rint(0, 5) != 0) {
                    chunkIn.func_177436_a(new BlockPos(x, pathY - 1, z), toPlace.func_176223_P(), false);
                }
                if (Utilities.rint(0, 15) == 0) {
                    chunkIn.func_177436_a(new BlockPos(x, pathY - 1, z), Blocks.field_150351_n.func_176223_P(), false);
                }
                if (Utilities.rint(0, 30) == 0) {
                    LocatePath.paths.add(new BlockPos(x, pathY, z));
                }
            }
        }
    }

    public double[] applyPathNoise(int x, int z) {
        return this.getPathNoise(x, z, 0.005, 0.01, 0.001, 50.0, 1.0);
    }

    public boolean isPath(double[] pathNoise) {
        return pathNoise[0] != 1.0;
    }

    private double[] getPathNoise(int x, int z, double freq, double threshold, double centerThreshold, double noiseMultiplier, double centerNoiseMultiplier) {
        OpenSimplex2S.Values2D1 results = new OpenSimplex2S.Values2D1();
        this.pathNoise.noise2((double)x * freq, (double)z * freq, results);
        double slope = Math.sqrt(results.dx * results.dx + results.dy * results.dy);
        double estDistanceToZero = Math.abs(results.value / slope);
        double vnoise = 1.0;
        if (estDistanceToZero < threshold) {
            vnoise = -(estDistanceToZero * noiseMultiplier);
        }
        double cnoise = 1.0;
        if (estDistanceToZero < centerThreshold) {
            cnoise = -(estDistanceToZero * centerNoiseMultiplier);
        }
        return new double[]{vnoise, cnoise};
    }
}

