/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.functions.interpolation;

import com.matez.wildnature.world.generation.biome.setup.BiomeVariants;
import com.matez.wildnature.world.generation.generators.functions.interpolation.LerpConfiguration;
import com.matez.wildnature.world.generation.noise.fastNoise.FastNoise;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.function.Function;

public class BiomeBlender {
    public static FastNoise fastNoise = new FastNoise();

    public static double[] smoothLerp(int x, int z, Object2DoubleMap<LerpConfiguration> weightMap1, Function<LerpConfiguration, BiomeVariants> variantAccessor) {
        double totalHeight = 0.0;
        double totalHeightVariation = 0.0;
        for (Object2DoubleMap.Entry entry : weightMap1.object2DoubleEntrySet()) {
            BiomeVariants variants = variantAccessor.apply((LerpConfiguration)entry.getKey());
            double weight = entry.getDoubleValue();
            double height = weight * BiomeBlender.modifyDepth(weight, BiomeBlender.getDepth(((LerpConfiguration)entry.getKey()).getDepth()), x, z);
            double heightVariation = weight * BiomeBlender.getScale(((LerpConfiguration)entry.getKey()).getScale());
            totalHeight += height;
            totalHeightVariation += heightVariation;
        }
        return new double[]{totalHeight, totalHeightVariation};
    }

    public static double modifyDepth(double weight, double depth, int x, int z) {
        double factor = depth / 256.0 * (weight * 3.0);
        double fractal = fastNoise.GetSimplexFractal(x, z);
        double scaledFractal = fractal * 20.0;
        return depth + scaledFractal * factor;
    }

    public static double getDepth(float depth) {
        int max = 200;
        int min = 40;
        int baseValue = 75;
        float sampledDepth = (float)baseValue * (depth > 0.0f ? depth + 1.0f : depth - 1.0f);
        sampledDepth = Math.min(sampledDepth, (float)max);
        sampledDepth = Math.max(sampledDepth, (float)min);
        return sampledDepth;
    }

    public static double getScale(float scale) {
        return scale * 7.0f;
    }

    static {
        fastNoise.SetFractalOctaves(5);
        fastNoise.SetFractalType(FastNoise.FractalType.FBM);
        fastNoise.SetFractalGain(2.0f);
        fastNoise.SetFractalLacunarity(2.0f);
    }
}

