/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.generators.rivers.surface;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class RiverGenerator {
    private BlockState AIR = Blocks.field_150350_a.func_176223_P();

    public RiverGenerator(IWorld worldIn) {
    }

    public void generate(int x, int y, int z, Biome biome, IChunk chunkIn) {
        this.generateRiverValley(x, y, z, 20, chunkIn);
    }

    private void generateRiverValley(int x, int y, int z, int radius, IChunk chunk) {
        for (int circleX = -radius; circleX <= radius; ++circleX) {
            for (int circleZ = -radius; circleZ <= radius; ++circleZ) {
                if (circleX * circleX + circleZ * circleZ > radius * radius) continue;
                int posX = circleX + x;
                int posZ = circleZ + z;
                this.carve(posX, posZ, y, this.getHeightForPosition(posX, posZ, x, y, z), this.AIR, chunk);
            }
        }
    }

    private int getHeightForPosition(int posX, int posZ, int centerX, int centerY, int centerZ) {
        int xDelta = centerX - posX;
        int zDelta = centerZ - posZ;
        double xFactor = (double)xDelta / (double)posX;
        double zFactor = (double)zDelta / (double)posZ;
        return (int)Math.round(Math.floor((double)centerY / (xFactor * zFactor)));
    }

    private void carve(int x, int z, int oldY, int newY, BlockState blockState, IChunk chunk) {
        block4: {
            BlockPos.Mutable pos = new BlockPos.Mutable(x, 0, z);
            if (oldY == newY) break block4;
            if (oldY > newY) {
                for (int i = oldY; i > newY; --i) {
                    pos.func_185336_p(i);
                    chunk.func_177436_a((BlockPos)pos, blockState, false);
                }
            } else {
                for (int i = oldY; i < newY; ++i) {
                    pos.func_185336_p(i);
                    chunk.func_177436_a((BlockPos)pos, blockState, false);
                }
            }
        }
    }
}

