/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.noise;

public class ModuleBase {
    public ModuleBase[] sourceModules;
    public int modulesRequired;

    public ModuleBase() {
        this.modulesRequired = 0;
    }

    public ModuleBase(int modulesRequired) {
        if (modulesRequired > 0) {
            this.sourceModules = new ModuleBase[modulesRequired];
            for (int i = 0; i < modulesRequired; ++i) {
                this.sourceModules[i] = new ModuleBase();
            }
        } else {
            this.sourceModules = null;
        }
        this.modulesRequired = modulesRequired;
    }

    public ModuleBase getSourceModule(int index) throws NullPointerException {
        if (this.sourceModules != null) {
            if (index >= this.getSourceModuleCount() || index < 0 || this.sourceModules[index] == null) {
                throw new NullPointerException("Could not retrieve a source module from a noise module.");
            }
            return this.sourceModules[index];
        }
        throw new NullPointerException("Could not retrieve a source module from a noise module.");
    }

    public int getSourceModuleCount() {
        return this.modulesRequired;
    }

    public double getValue(double x, double y, double z) {
        return x;
    }

    public void setSourceModule(int index, ModuleBase sourceModule) throws NullPointerException {
        if (this.sourceModules != null && (index >= this.getSourceModuleCount() || index < 0)) {
            throw new NullPointerException("Invalid Parameter in ModuleBase");
        }
        this.sourceModules[index] = sourceModule;
    }
}

