/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.noise;

public class OpenSimplex2S {
    private static final int PSIZE = 2048;
    private static final int PMASK = 2047;
    private short[] perm;
    private Grad2[] permGrad2;
    private Grad3[] permGrad3;
    private Grad4[] permGrad4;
    private long seed;
    private static final LatticePoint2D[] LOOKUP_2D;
    private static final LatticePoint3D[] LOOKUP_3D;
    private static final LatticePoint4D[][] LOOKUP_4D;
    public static final double N2 = 0.05481866495625118;
    public static final double N3 = 0.2781926117527186;
    public static final double N4 = 0.11127401889945551;
    private static final Grad2[] GRADIENTS_2D;
    private static final Grad3[] GRADIENTS_3D;
    private static final Grad3[] GRADIENTS_3D_CLASSIC;
    private static final Grad3[] GRADIENTS_3D_XY_BEFORE_Z;
    private static final Grad3[] GRADIENTS_3D_XZ_BEFORE_Y;
    private static final Grad4[] GRADIENTS_4D;

    public OpenSimplex2S(long seed) {
        int i;
        this.seed = seed;
        this.perm = new short[2048];
        this.permGrad2 = new Grad2[2048];
        this.permGrad3 = new Grad3[2048];
        this.permGrad4 = new Grad4[2048];
        short[] source = new short[2048];
        for (i = 0; i < 2048; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 2047; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.permGrad2[i] = GRADIENTS_2D[this.perm[i]];
            this.permGrad3[i] = GRADIENTS_3D[this.perm[i]];
            this.permGrad4[i] = GRADIENTS_4D[this.perm[i]];
            source[r] = source[i];
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        int i;
        this.seed = seed;
        this.perm = new short[2048];
        this.permGrad2 = new Grad2[2048];
        this.permGrad3 = new Grad3[2048];
        this.permGrad4 = new Grad4[2048];
        short[] source = new short[2048];
        for (i = 0; i < 2048; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 2047; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.permGrad2[i] = GRADIENTS_2D[this.perm[i]];
            this.permGrad3[i] = GRADIENTS_3D[this.perm[i]];
            this.permGrad4[i] = GRADIENTS_4D[this.perm[i]];
            source[r] = source[i];
        }
    }

    public double noise2(double x, double y) {
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        return this.noise2_Base(xs, ys);
    }

    public double noise2_XBeforeY(double x, double y) {
        double xx = x * 0.7071067811865476;
        double yy = y * 1.224744871380249;
        return this.noise2_Base(yy + xx, yy - xx);
    }

    private double noise2_Base(double xs, double ys) {
        double value = 0.0;
        int xsb = OpenSimplex2S.fastFloor(xs);
        int ysb = OpenSimplex2S.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(xsi + ysi);
        int index = a << 2 | (int)(xsi - ysi / 2.0 + 1.0 - (double)a / 2.0) << 3 | (int)(ysi - xsi / 2.0 + 1.0 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * -0.211324865405187;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 0.6666666666666666 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            int pxm = xsb + c.xsv & 0x7FF;
            int pym = ysb + c.ysv & 0x7FF;
            Grad2 grad = this.permGrad2[this.perm[pxm] ^ pym];
            double extrapolation = grad.dx * dx + grad.dy * dy;
            attn *= attn;
            value += attn * attn * extrapolation;
        }
        return value;
    }

    public void noise2(double x, double y, Values2D1 output) {
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        this.noise2_Base(xs, ys, output);
    }

    private void noise2_Base(double xs, double ys, Values2D1 output) {
        output.dy = 0.0;
        output.dx = 0.0;
        output.value = 0.0;
        int xsb = OpenSimplex2S.fastFloor(xs);
        int ysb = OpenSimplex2S.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(xsi + ysi);
        int index = a << 2 | (int)(xsi - ysi / 2.0 + 1.0 - (double)a / 2.0) << 3 | (int)(ysi - xsi / 2.0 + 1.0 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * -0.211324865405187;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 0.6666666666666666 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            int pxm = xsb + c.xsv & 0x7FF;
            int pym = ysb + c.ysv & 0x7FF;
            Grad2 grad = this.permGrad2[this.perm[pxm] ^ pym];
            double extrapolation = grad.dx * dx + grad.dy * dy;
            double attnSq = attn * attn;
            output.value += attnSq * attnSq * extrapolation;
            output.dx += (grad.dx * attn - 8.0 * dx * extrapolation) * attnSq * attn;
            output.dy += (grad.dy * attn - 8.0 * dy * extrapolation) * attnSq * attn;
        }
    }

    public double noise3_Classic(double x, double y, double z) {
        double r = 0.6666666666666666 * (x + y + z);
        double xr = r - x;
        double yr = r - y;
        double zr = r - z;
        return this.noise3_BCC(xr, yr, zr);
    }

    public double noise3_XYBeforeZ(double x, double y, double z) {
        double xy = x + y;
        double s2 = xy * -0.211324865405187;
        double zz = z * 0.577350269189626;
        double xr = x + s2 - zz;
        double yr = y + s2 - zz;
        double zr = xy * 0.577350269189626 + zz;
        return this.noise3_BCC(xr, yr, zr);
    }

    public double noise3_XZBeforeY(double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.577350269189626;
        double xr = x + s2 - yy;
        double zr = z + s2 - yy;
        double yr = xz * 0.577350269189626 + yy;
        return this.noise3_BCC(xr, yr, zr);
    }

    private double noise3_BCC(double xr, double yr, double zr) {
        int xrb = OpenSimplex2S.fastFloor(xr);
        int yrb = OpenSimplex2S.fastFloor(yr);
        int zrb = OpenSimplex2S.fastFloor(zr);
        double xri = xr - (double)xrb;
        double yri = yr - (double)yrb;
        double zri = zr - (double)zrb;
        int xht = (int)(xri + 0.5);
        int yht = (int)(yri + 0.5);
        int zht = (int)(zri + 0.5);
        int index = xht << 0 | yht << 1 | zht << 2;
        double value = 0.0;
        LatticePoint3D c = LOOKUP_3D[index];
        while (c != null) {
            double dxr = xri + c.dxr;
            double dyr = yri + c.dyr;
            double dzr = zri + c.dzr;
            double attn = 0.75 - dxr * dxr - dyr * dyr - dzr * dzr;
            if (attn < 0.0) {
                c = c.nextOnFailure;
                continue;
            }
            int pxm = xrb + c.xrv & 0x7FF;
            int pym = yrb + c.yrv & 0x7FF;
            int pzm = zrb + c.zrv & 0x7FF;
            Grad3 grad = this.permGrad3[this.perm[this.perm[pxm] ^ pym] ^ pzm];
            double extrapolation = grad.dx * dxr + grad.dy * dyr + grad.dz * dzr;
            attn *= attn;
            value += attn * attn * extrapolation;
            c = c.nextOnSuccess;
        }
        return value;
    }

    public void noise3_Classic(double x, double y, double z, Values3D1 output) {
        double r = 0.6666666666666666 * (x + y + z);
        double xr = r - x;
        double yr = r - y;
        double zr = r - z;
        this.noise3_BCC(xr, yr, zr, output, GRADIENTS_3D_CLASSIC);
    }

    public void noise3_XYBeforeZ(double x, double y, double z, Values3D1 output) {
        double xy = x + y;
        double s2 = xy * -0.211324865405187;
        double zz = z * 0.577350269189626;
        double xr = x + s2 - zz;
        double yr = y + s2 - zz;
        double zr = xy * 0.577350269189626 + zz;
        this.noise3_BCC(xr, yr, zr, output, GRADIENTS_3D_XY_BEFORE_Z);
    }

    public void noise3_XZBeforeY(double x, double y, double z, Values3D1 output) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.577350269189626;
        double xr = x + s2 - yy;
        double zr = z + s2 - yy;
        double yr = xz * 0.577350269189626 + yy;
        this.noise3_BCC(xr, yr, zr, output, GRADIENTS_3D_XZ_BEFORE_Y);
    }

    private void noise3_BCC(double xr, double yr, double zr, Values3D1 output, Grad3[] derivativeGrads) {
        output.dz = 0.0;
        output.dy = 0.0;
        output.dx = 0.0;
        output.value = 0.0;
        int xrb = OpenSimplex2S.fastFloor(xr);
        int yrb = OpenSimplex2S.fastFloor(yr);
        int zrb = OpenSimplex2S.fastFloor(zr);
        double xri = xr - (double)xrb;
        double yri = yr - (double)yrb;
        double zri = zr - (double)zrb;
        int xht = (int)(xri + 0.5);
        int yht = (int)(yri + 0.5);
        int zht = (int)(zri + 0.5);
        int index = xht << 0 | yht << 1 | zht << 2;
        double value = 0.0;
        LatticePoint3D c = LOOKUP_3D[index];
        while (c != null) {
            double dxr = xri + c.dxr;
            double dyr = yri + c.dyr;
            double dzr = zri + c.dzr;
            double attn = 0.75 - dxr * dxr - dyr * dyr - dzr * dzr;
            if (attn < 0.0) {
                c = c.nextOnFailure;
                continue;
            }
            int pxm = xrb + c.xrv & 0x7FF;
            int pym = yrb + c.yrv & 0x7FF;
            int pzm = zrb + c.zrv & 0x7FF;
            int zPermXY = this.perm[this.perm[pxm] ^ pym] ^ pzm;
            Grad3 grad = this.permGrad3[zPermXY];
            double extrapolation = grad.dx * dxr + grad.dy * dyr + grad.dz * dzr;
            Grad3 dGrad = derivativeGrads[this.perm[zPermXY]];
            double attnSq = attn * attn;
            output.value += attnSq * attnSq * extrapolation;
            output.dx += (dGrad.dx * attn - 8.0 * dxr * extrapolation) * attnSq * attn;
            output.dy += (dGrad.dy * attn - 8.0 * dyr * extrapolation) * attnSq * attn;
            output.dz += (dGrad.dz * attn - 8.0 * dzr * extrapolation) * attnSq * attn;
            c = c.nextOnSuccess;
        }
    }

    public double noise4_Classic(double x, double y, double z, double w) {
        double s = 0.309016994374947 * (x + y + z + w);
        double xs = x + s;
        double ys = y + s;
        double zs = z + s;
        double ws = w + s;
        return this.noise4_Base(xs, ys, zs, ws);
    }

    public double noise4_XYBeforeZW(double x, double y, double z, double w) {
        double s2 = (x + y) * -0.2852251398743488 + (z + w) * 0.8389706547061143;
        double t2 = (z + w) * 0.21939749883706436 + (x + y) * -0.48214856493302477;
        double xs = x + s2;
        double ys = y + s2;
        double zs = z + t2;
        double ws = w + t2;
        return this.noise4_Base(xs, ys, zs, ws);
    }

    public double noise4_XZBeforeYW(double x, double y, double z, double w) {
        double s2 = (x + z) * -0.2852251398743488 + (y + w) * 0.8389706547061143;
        double t2 = (y + w) * 0.21939749883706436 + (x + z) * -0.48214856493302477;
        double xs = x + s2;
        double ys = y + t2;
        double zs = z + s2;
        double ws = w + t2;
        return this.noise4_Base(xs, ys, zs, ws);
    }

    public double noise4_XYZBeforeW(double x, double y, double z, double w) {
        double xyz = x + y + z;
        double ww = w * 1.118033988749894;
        double s2 = xyz / -6.0 + ww;
        double xs = x + s2;
        double ys = y + s2;
        double zs = z + s2;
        double ws = -0.5 * xyz + ww;
        return this.noise4_Base(xs, ys, zs, ws);
    }

    private double noise4_Base(double xs, double ys, double zs, double ws) {
        double value = 0.0;
        int xsb = OpenSimplex2S.fastFloor(xs);
        int ysb = OpenSimplex2S.fastFloor(ys);
        int zsb = OpenSimplex2S.fastFloor(zs);
        int wsb = OpenSimplex2S.fastFloor(ws);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        double zsi = zs - (double)zsb;
        double wsi = ws - (double)wsb;
        double ssi = (xsi + ysi + zsi + wsi) * -0.138196601125011;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        double zi = zsi + ssi;
        double wi = wsi + ssi;
        int index = (OpenSimplex2S.fastFloor(xs * 4.0) & 3) << 0 | (OpenSimplex2S.fastFloor(ys * 4.0) & 3) << 2 | (OpenSimplex2S.fastFloor(zs * 4.0) & 3) << 4 | (OpenSimplex2S.fastFloor(ws * 4.0) & 3) << 6;
        for (LatticePoint4D c : LOOKUP_4D[index]) {
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double dz = zi + c.dz;
            double dw = wi + c.dw;
            double attn = 0.8 - dx * dx - dy * dy - dz * dz - dw * dw;
            if (!(attn > 0.0)) continue;
            attn *= attn;
            int pxm = xsb + c.xsv & 0x7FF;
            int pym = ysb + c.ysv & 0x7FF;
            int pzm = zsb + c.zsv & 0x7FF;
            int pwm = wsb + c.wsv & 0x7FF;
            Grad4 grad = this.permGrad4[this.perm[this.perm[this.perm[pxm] ^ pym] ^ pzm] ^ pwm];
            double extrapolation = grad.dx * dx + grad.dy * dy + grad.dz * dz + grad.dw * dw;
            value += attn * attn * extrapolation;
        }
        return value;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    /*
     * Opcode count of 18268 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        int i2;
        int i3;
        int j1;
        int i1;
        int i4;
        LOOKUP_2D = new LatticePoint2D[32];
        LOOKUP_3D = new LatticePoint3D[8];
        LOOKUP_4D = new LatticePoint4D[256][];
        for (i4 = 0; i4 < 8; ++i4) {
            int j2;
            int i22;
            if ((i4 & 1) == 0) {
                if ((i4 & 2) == 0) {
                    i1 = -1;
                    j1 = 0;
                } else {
                    i1 = 1;
                    j1 = 0;
                }
                if ((i4 & 4) == 0) {
                    i22 = 0;
                    j2 = -1;
                } else {
                    i22 = 0;
                    j2 = 1;
                }
            } else {
                if ((i4 & 2) != 0) {
                    i1 = 2;
                    j1 = 1;
                } else {
                    i1 = 0;
                    j1 = 1;
                }
                if ((i4 & 4) != 0) {
                    i22 = 1;
                    j2 = 2;
                } else {
                    i22 = 1;
                    j2 = 0;
                }
            }
            OpenSimplex2S.LOOKUP_2D[i4 * 4 + 0] = new LatticePoint2D(0, 0);
            OpenSimplex2S.LOOKUP_2D[i4 * 4 + 1] = new LatticePoint2D(1, 1);
            OpenSimplex2S.LOOKUP_2D[i4 * 4 + 2] = new LatticePoint2D(i1, j1);
            OpenSimplex2S.LOOKUP_2D[i4 * 4 + 3] = new LatticePoint2D(i22, j2);
        }
        for (i4 = 0; i4 < 8; ++i4) {
            i1 = i4 >> 0 & 1;
            j1 = i4 >> 1 & 1;
            int k1 = i4 >> 2 & 1;
            int i23 = i1 ^ 1;
            int j2 = j1 ^ 1;
            int k2 = k1 ^ 1;
            LatticePoint3D c0 = new LatticePoint3D(i1, j1, k1, 0);
            LatticePoint3D c1 = new LatticePoint3D(i1 + i23, j1 + j2, k1 + k2, 1);
            LatticePoint3D c2 = new LatticePoint3D(i1 ^ 1, j1, k1, 0);
            LatticePoint3D c3 = new LatticePoint3D(i1, j1 ^ 1, k1 ^ 1, 0);
            LatticePoint3D c4 = new LatticePoint3D(i1 + (i23 ^ 1), j1 + j2, k1 + k2, 1);
            LatticePoint3D c5 = new LatticePoint3D(i1 + i23, j1 + (j2 ^ 1), k1 + (k2 ^ 1), 1);
            LatticePoint3D c6 = new LatticePoint3D(i1, j1 ^ 1, k1, 0);
            LatticePoint3D c7 = new LatticePoint3D(i1 ^ 1, j1, k1 ^ 1, 0);
            LatticePoint3D c8 = new LatticePoint3D(i1 + i23, j1 + (j2 ^ 1), k1 + k2, 1);
            LatticePoint3D c9 = new LatticePoint3D(i1 + (i23 ^ 1), j1 + j2, k1 + (k2 ^ 1), 1);
            LatticePoint3D cA = new LatticePoint3D(i1, j1, k1 ^ 1, 0);
            LatticePoint3D cB = new LatticePoint3D(i1 ^ 1, j1 ^ 1, k1, 0);
            LatticePoint3D cC = new LatticePoint3D(i1 + i23, j1 + j2, k1 + (k2 ^ 1), 1);
            LatticePoint3D cD = new LatticePoint3D(i1 + (i23 ^ 1), j1 + (j2 ^ 1), k1 + k2, 1);
            c0.nextOnFailure = c0.nextOnSuccess = c1;
            c1.nextOnFailure = c1.nextOnSuccess = c2;
            c2.nextOnFailure = c3;
            c2.nextOnSuccess = c5;
            c3.nextOnFailure = c4;
            c3.nextOnSuccess = c4;
            c4.nextOnFailure = c5;
            c4.nextOnSuccess = c6;
            c5.nextOnFailure = c5.nextOnSuccess = c6;
            c6.nextOnFailure = c7;
            c6.nextOnSuccess = c9;
            c7.nextOnFailure = c8;
            c7.nextOnSuccess = c8;
            c8.nextOnFailure = c9;
            c8.nextOnSuccess = cA;
            c9.nextOnFailure = c9.nextOnSuccess = cA;
            cA.nextOnFailure = cB;
            cA.nextOnSuccess = cD;
            cB.nextOnFailure = cC;
            cB.nextOnSuccess = cC;
            cC.nextOnFailure = cD;
            cC.nextOnSuccess = null;
            cD.nextOnSuccess = null;
            cD.nextOnFailure = null;
            OpenSimplex2S.LOOKUP_3D[i4] = c0;
        }
        int[][] lookup4DPregen = new int[][]{{21, 69, 81, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170}, {1, 5, 17, 21, 65, 69, 81, 85, 86, 90, 102, 106, 150, 154, 166, 170}, {1, 21, 22, 69, 70, 81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 102, 106, 150, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 102, 106, 150, 154, 170, 171}, {4, 5, 20, 21, 68, 69, 84, 85, 89, 90, 105, 106, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 105, 106, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 106, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 91, 106, 154, 170, 171}, {4, 21, 25, 69, 73, 84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 105, 106, 153, 154, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 94, 106, 154, 170, 174}, {5, 21, 26, 69, 74, 85, 86, 89, 90, 91, 94, 106, 154, 170, 171, 174, 175}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 165, 166, 170}, {17, 21, 81, 85, 86, 90, 101, 102, 106, 150, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 90, 101, 102, 106, 150, 166, 170, 171}, {20, 21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 149, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {21, 22, 85, 86, 90, 102, 106, 107, 150, 154, 166, 170, 171}, {20, 21, 84, 85, 89, 90, 101, 105, 106, 153, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 170}, {21, 22, 85, 86, 89, 90, 102, 106, 107, 154, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 90, 101, 105, 106, 153, 169, 170, 174}, {21, 25, 85, 89, 90, 105, 106, 110, 153, 154, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 105, 106, 110, 154, 170, 174}, {21, 26, 85, 86, 89, 90, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 17, 20, 21, 80, 81, 84, 85, 101, 102, 105, 106, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 101, 102, 105, 106, 165, 166, 170}, {17, 21, 81, 85, 86, 101, 102, 106, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 101, 102, 103, 106, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 102, 105, 106, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 166, 170}, {21, 22, 85, 86, 90, 101, 102, 106, 107, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 170}, {21, 22, 85, 86, 89, 90, 101, 102, 105, 106, 107, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 101, 105, 106, 109, 169, 170, 174}, {21, 25, 85, 89, 90, 101, 105, 106, 110, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 101, 102, 105, 106, 110, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 21, 37, 81, 84, 85, 97, 100, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 105, 106, 165, 166, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 106, 118, 166, 170, 186}, {17, 21, 38, 81, 85, 86, 98, 101, 102, 103, 106, 118, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 102, 105, 106, 165, 169, 170, 186}, {21, 37, 85, 101, 102, 105, 106, 122, 165, 166, 169, 170, 186}, {21, 37, 85, 86, 101, 102, 105, 106, 122, 166, 170, 186}, {21, 38, 85, 86, 101, 102, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 105, 106, 121, 169, 170, 186}, {21, 37, 85, 89, 101, 102, 105, 106, 122, 169, 170, 186}, {21, 37, 85, 86, 89, 90, 101, 102, 105, 106, 122, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 41, 84, 85, 89, 101, 104, 105, 106, 109, 121, 169, 170, 174, 186, 190}, {21, 41, 85, 89, 101, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 107, 110, 122, 170, 171, 174, 186, 191}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 89, 90, 101, 102, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 90, 102, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 90, 102, 149, 150, 154, 166, 170, 171}, {68, 69, 84, 85, 86, 89, 90, 101, 105, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 101, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {69, 70, 85, 86, 90, 102, 106, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 90, 105, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 106, 150, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 90, 105, 149, 153, 154, 169, 170, 174}, {69, 73, 85, 89, 90, 105, 106, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 106, 153, 154, 158, 170, 174}, {69, 74, 85, 86, 89, 90, 106, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 86, 89, 101, 102, 105, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 89, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 167, 170, 171}, {84, 85, 86, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170, 171}, {85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170, 174}, {21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174}, {85, 86, 89, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 102, 105, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 106, 150, 166, 167, 170, 171}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186}, {85, 86, 90, 101, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 106, 149, 153, 165, 169, 170}, {21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 101, 105, 106, 153, 169, 170, 173, 174}, {85, 89, 90, 101, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 102, 105, 149, 165, 166, 169, 170, 186}, {81, 85, 97, 101, 102, 105, 106, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 106, 165, 166, 170, 182, 186}, {81, 85, 86, 98, 101, 102, 106, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 102, 105, 106, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 106, 165, 169, 170, 185, 186}, {85, 89, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 101, 104, 105, 106, 169, 170, 173, 174, 185, 186, 190}, {85, 89, 101, 105, 106, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 170, 171, 174, 186, 191}, {64, 65, 68, 69, 80, 81, 84, 85, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 149, 150, 151, 154, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 166, 170}, {69, 70, 85, 86, 90, 149, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 149, 150, 153, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 149, 153, 154, 157, 169, 170, 174}, {69, 73, 85, 89, 90, 149, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 149, 150, 153, 154, 158, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 154, 165, 166, 170}, {81, 82, 85, 86, 102, 149, 150, 154, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234}, {85, 86, 90, 102, 106, 149, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 154, 165, 169, 170}, {69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {84, 85, 88, 89, 105, 149, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 149, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 166, 169, 170}, {81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234}, {81, 85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170}, {84, 85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 169, 170, 171}, {84, 85, 88, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 166, 169, 170, 174}, {85, 86, 89, 90, 102, 105, 106, 150, 153, 154, 166, 169, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 149, 165, 166, 169, 170, 181, 186}, {81, 85, 97, 101, 102, 149, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 149, 150, 165, 166, 170, 182, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 105, 149, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 149, 153, 165, 169, 170, 185, 186}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {85, 86, 89, 101, 102, 105, 106, 149, 154, 165, 166, 169, 170, 186}, {85, 86, 90, 101, 102, 105, 106, 150, 154, 165, 166, 169, 170, 171, 186, 187}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 173, 174, 185, 186, 190}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 174, 186, 190}, {85, 89, 90, 101, 102, 105, 106, 153, 154, 165, 166, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170, 171, 174, 186}, {64, 69, 81, 84, 85, 133, 145, 148, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 153, 154, 165, 166, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 154, 166, 170, 214, 234}, {65, 69, 81, 85, 86, 134, 146, 149, 150, 151, 154, 166, 170, 171, 214, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 150, 153, 154, 165, 169, 170, 234}, {69, 85, 133, 149, 150, 153, 154, 165, 166, 169, 170, 218, 234}, {69, 85, 86, 133, 149, 150, 153, 154, 166, 170, 218, 234}, {69, 85, 86, 134, 149, 150, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 153, 154, 169, 170, 217, 234}, {69, 85, 89, 133, 149, 150, 153, 154, 169, 170, 218, 234}, {69, 85, 86, 89, 90, 133, 149, 150, 153, 154, 170, 218, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 137, 149, 152, 153, 154, 157, 169, 170, 174, 217, 234, 238}, {69, 85, 89, 137, 149, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 155, 158, 170, 171, 174, 218, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 150, 153, 165, 166, 169, 170, 234}, {81, 85, 145, 149, 150, 153, 154, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 145, 149, 150, 154, 165, 166, 170, 230, 234}, {81, 85, 86, 146, 149, 150, 154, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 148, 149, 150, 153, 154, 165, 166, 169, 170, 233, 234}, {85, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 148, 149, 153, 154, 165, 169, 170, 233, 234}, {85, 89, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 149, 152, 153, 154, 169, 170, 173, 174, 233, 234, 238}, {85, 89, 149, 153, 154, 169, 170, 174, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 149, 150, 153, 154, 170, 171, 174, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 165, 166, 169, 170, 229, 234}, {81, 85, 101, 145, 149, 150, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 101, 102, 145, 149, 150, 165, 166, 170, 230, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 101, 148, 149, 153, 165, 166, 169, 170, 233, 234}, {85, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 170, 171, 234, 235}, {84, 85, 89, 101, 105, 148, 149, 153, 165, 169, 170, 233, 234}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 89, 101, 106, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 90, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234, 235}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 173, 174, 233, 234, 238}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 174, 234, 238}, {85, 89, 90, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174, 234}, {80, 81, 84, 85, 101, 149, 161, 164, 165, 166, 169, 170, 181, 186, 229, 234, 250}, {81, 85, 101, 149, 161, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171, 182, 186, 230, 234, 251}, {84, 85, 101, 149, 164, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {85, 101, 149, 165, 166, 169, 170, 186, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 149, 150, 165, 166, 170, 171, 186, 234, 251}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 186, 234, 250}, {85, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186, 234}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174, 185, 186, 233, 234, 254}, {85, 89, 101, 105, 149, 153, 165, 169, 170, 174, 186, 234, 254}, {85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186, 234}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 174, 186, 234}};
        LatticePoint4D[] latticePoints = new LatticePoint4D[256];
        for (i3 = 0; i3 < 256; ++i3) {
            int cx = (i3 >> 0 & 3) - 1;
            int cy = (i3 >> 2 & 3) - 1;
            int cz = (i3 >> 4 & 3) - 1;
            int cw = (i3 >> 6 & 3) - 1;
            latticePoints[i3] = new LatticePoint4D(cx, cy, cz, cw);
        }
        for (i3 = 0; i3 < 256; ++i3) {
            OpenSimplex2S.LOOKUP_4D[i3] = new LatticePoint4D[lookup4DPregen[i3].length];
            for (int j = 0; j < lookup4DPregen[i3].length; ++j) {
                OpenSimplex2S.LOOKUP_4D[i3][j] = latticePoints[lookup4DPregen[i3][j]];
            }
        }
        GRADIENTS_2D = new Grad2[2048];
        Grad2[] grad2 = new Grad2[]{new Grad2(0.130526192220052, 0.99144486137381), new Grad2(0.38268343236509, 0.923879532511287), new Grad2(0.608761429008721, 0.793353340291235), new Grad2(0.793353340291235, 0.608761429008721), new Grad2(0.923879532511287, 0.38268343236509), new Grad2(0.99144486137381, 0.130526192220051), new Grad2(0.99144486137381, -0.130526192220051), new Grad2(0.923879532511287, -0.38268343236509), new Grad2(0.793353340291235, -0.60876142900872), new Grad2(0.608761429008721, -0.793353340291235), new Grad2(0.38268343236509, -0.923879532511287), new Grad2(0.130526192220052, -0.99144486137381), new Grad2(-0.130526192220052, -0.99144486137381), new Grad2(-0.38268343236509, -0.923879532511287), new Grad2(-0.608761429008721, -0.793353340291235), new Grad2(-0.793353340291235, -0.608761429008721), new Grad2(-0.923879532511287, -0.38268343236509), new Grad2(-0.99144486137381, -0.130526192220052), new Grad2(-0.99144486137381, 0.130526192220051), new Grad2(-0.923879532511287, 0.38268343236509), new Grad2(-0.793353340291235, 0.608761429008721), new Grad2(-0.608761429008721, 0.793353340291235), new Grad2(-0.38268343236509, 0.923879532511287), new Grad2(-0.130526192220052, 0.99144486137381)};
        Grad2[] grad2XBeforeY = new Grad2[grad2.length];
        for (i3 = 0; i3 < grad2.length; ++i3) {
            grad2[i3].dx /= 0.05481866495625118;
            grad2[i3].dy /= 0.05481866495625118;
        }
        for (i3 = 0; i3 < 2048; ++i3) {
            OpenSimplex2S.GRADIENTS_2D[i3] = grad2[i3 % grad2.length];
        }
        GRADIENTS_3D = new Grad3[2048];
        GRADIENTS_3D_CLASSIC = new Grad3[2048];
        GRADIENTS_3D_XY_BEFORE_Z = new Grad3[2048];
        GRADIENTS_3D_XZ_BEFORE_Y = new Grad3[2048];
        Grad3[] grad3 = new Grad3[]{new Grad3(-2.22474487139, -2.22474487139, -1.0), new Grad3(-2.22474487139, -2.22474487139, 1.0), new Grad3(-3.0862664687972017, -1.1721513422464978, 0.0), new Grad3(-1.1721513422464978, -3.0862664687972017, 0.0), new Grad3(-2.22474487139, -1.0, -2.22474487139), new Grad3(-2.22474487139, 1.0, -2.22474487139), new Grad3(-1.1721513422464978, 0.0, -3.0862664687972017), new Grad3(-3.0862664687972017, 0.0, -1.1721513422464978), new Grad3(-2.22474487139, -1.0, 2.22474487139), new Grad3(-2.22474487139, 1.0, 2.22474487139), new Grad3(-3.0862664687972017, 0.0, 1.1721513422464978), new Grad3(-1.1721513422464978, 0.0, 3.0862664687972017), new Grad3(-2.22474487139, 2.22474487139, -1.0), new Grad3(-2.22474487139, 2.22474487139, 1.0), new Grad3(-1.1721513422464978, 3.0862664687972017, 0.0), new Grad3(-3.0862664687972017, 1.1721513422464978, 0.0), new Grad3(-1.0, -2.22474487139, -2.22474487139), new Grad3(1.0, -2.22474487139, -2.22474487139), new Grad3(0.0, -3.0862664687972017, -1.1721513422464978), new Grad3(0.0, -1.1721513422464978, -3.0862664687972017), new Grad3(-1.0, -2.22474487139, 2.22474487139), new Grad3(1.0, -2.22474487139, 2.22474487139), new Grad3(0.0, -1.1721513422464978, 3.0862664687972017), new Grad3(0.0, -3.0862664687972017, 1.1721513422464978), new Grad3(-1.0, 2.22474487139, -2.22474487139), new Grad3(1.0, 2.22474487139, -2.22474487139), new Grad3(0.0, 1.1721513422464978, -3.0862664687972017), new Grad3(0.0, 3.0862664687972017, -1.1721513422464978), new Grad3(-1.0, 2.22474487139, 2.22474487139), new Grad3(1.0, 2.22474487139, 2.22474487139), new Grad3(0.0, 3.0862664687972017, 1.1721513422464978), new Grad3(0.0, 1.1721513422464978, 3.0862664687972017), new Grad3(2.22474487139, -2.22474487139, -1.0), new Grad3(2.22474487139, -2.22474487139, 1.0), new Grad3(1.1721513422464978, -3.0862664687972017, 0.0), new Grad3(3.0862664687972017, -1.1721513422464978, 0.0), new Grad3(2.22474487139, -1.0, -2.22474487139), new Grad3(2.22474487139, 1.0, -2.22474487139), new Grad3(3.0862664687972017, 0.0, -1.1721513422464978), new Grad3(1.1721513422464978, 0.0, -3.0862664687972017), new Grad3(2.22474487139, -1.0, 2.22474487139), new Grad3(2.22474487139, 1.0, 2.22474487139), new Grad3(1.1721513422464978, 0.0, 3.0862664687972017), new Grad3(3.0862664687972017, 0.0, 1.1721513422464978), new Grad3(2.22474487139, 2.22474487139, -1.0), new Grad3(2.22474487139, 2.22474487139, 1.0), new Grad3(3.0862664687972017, 1.1721513422464978, 0.0), new Grad3(1.1721513422464978, 3.0862664687972017, 0.0)};
        Grad3[] grad3Classic = new Grad3[grad3.length];
        Grad3[] grad3XYBeforeZ = new Grad3[grad3.length];
        Grad3[] grad3XZBeforeY = new Grad3[grad3.length];
        for (i2 = 0; i2 < grad3.length; ++i2) {
            grad3[i2].dx /= 0.2781926117527186;
            grad3[i2].dy /= 0.2781926117527186;
            grad3[i2].dz /= 0.2781926117527186;
            double gxr = grad3[i2].dx;
            double gyr = grad3[i2].dy;
            double gzr = grad3[i2].dz;
            double grr = 0.6666666666666666 * (gxr + gyr + gzr);
            double dx = grr - gxr;
            double dy = grr - gyr;
            double dz = grr - gzr;
            grad3Classic[i2] = new Grad3(grr - gxr, grr - gyr, grr - gzr);
            double s2 = (gxr + gyr) * -0.211324865405187;
            double zz = gzr * 0.577350269189626;
            grad3XYBeforeZ[i2] = new Grad3(gxr + s2 + zz, gyr + s2 + zz, (gzr - gxr - gyr) * 0.577350269189626);
            s2 = (gxr + gzr) * -0.211324865405187;
            double yy = gyr * 0.577350269189626;
            grad3XZBeforeY[i2] = new Grad3(gxr + s2 + yy, (gyr - gxr - gzr) * 0.577350269189626, gzr + s2 + yy);
        }
        for (i2 = 0; i2 < 2048; ++i2) {
            OpenSimplex2S.GRADIENTS_3D[i2] = grad3[i2 % grad3.length];
            OpenSimplex2S.GRADIENTS_3D_CLASSIC[i2] = grad3Classic[i2 % grad3Classic.length];
            OpenSimplex2S.GRADIENTS_3D_XY_BEFORE_Z[i2] = grad3XYBeforeZ[i2 % grad3XYBeforeZ.length];
            OpenSimplex2S.GRADIENTS_3D_XZ_BEFORE_Y[i2] = grad3XZBeforeY[i2 % grad3XZBeforeY.length];
        }
        GRADIENTS_4D = new Grad4[2048];
        Grad4[] grad4 = new Grad4[]{new Grad4(-0.753341017856078, -0.37968289875261624, -0.37968289875261624, -0.37968289875261624), new Grad4(-0.7821684431180708, -0.4321472685365301, -0.4321472685365301, 0.12128480194602098), new Grad4(-0.7821684431180708, -0.4321472685365301, 0.12128480194602098, -0.4321472685365301), new Grad4(-0.7821684431180708, 0.12128480194602098, -0.4321472685365301, -0.4321472685365301), new Grad4(-0.8586508742123365, -0.508629699630796, 0.044802370851755174, 0.044802370851755174), new Grad4(-0.8586508742123365, 0.044802370851755174, -0.508629699630796, 0.044802370851755174), new Grad4(-0.8586508742123365, 0.044802370851755174, 0.044802370851755174, -0.508629699630796), new Grad4(-0.9982828964265062, -0.03381941603233842, -0.03381941603233842, -0.03381941603233842), new Grad4(-0.37968289875261624, -0.753341017856078, -0.37968289875261624, -0.37968289875261624), new Grad4(-0.4321472685365301, -0.7821684431180708, -0.4321472685365301, 0.12128480194602098), new Grad4(-0.4321472685365301, -0.7821684431180708, 0.12128480194602098, -0.4321472685365301), new Grad4(0.12128480194602098, -0.7821684431180708, -0.4321472685365301, -0.4321472685365301), new Grad4(-0.508629699630796, -0.8586508742123365, 0.044802370851755174, 0.044802370851755174), new Grad4(0.044802370851755174, -0.8586508742123365, -0.508629699630796, 0.044802370851755174), new Grad4(0.044802370851755174, -0.8586508742123365, 0.044802370851755174, -0.508629699630796), new Grad4(-0.03381941603233842, -0.9982828964265062, -0.03381941603233842, -0.03381941603233842), new Grad4(-0.37968289875261624, -0.37968289875261624, -0.753341017856078, -0.37968289875261624), new Grad4(-0.4321472685365301, -0.4321472685365301, -0.7821684431180708, 0.12128480194602098), new Grad4(-0.4321472685365301, 0.12128480194602098, -0.7821684431180708, -0.4321472685365301), new Grad4(0.12128480194602098, -0.4321472685365301, -0.7821684431180708, -0.4321472685365301), new Grad4(-0.508629699630796, 0.044802370851755174, -0.8586508742123365, 0.044802370851755174), new Grad4(0.044802370851755174, -0.508629699630796, -0.8586508742123365, 0.044802370851755174), new Grad4(0.044802370851755174, 0.044802370851755174, -0.8586508742123365, -0.508629699630796), new Grad4(-0.03381941603233842, -0.03381941603233842, -0.9982828964265062, -0.03381941603233842), new Grad4(-0.37968289875261624, -0.37968289875261624, -0.37968289875261624, -0.753341017856078), new Grad4(-0.4321472685365301, -0.4321472685365301, 0.12128480194602098, -0.7821684431180708), new Grad4(-0.4321472685365301, 0.12128480194602098, -0.4321472685365301, -0.7821684431180708), new Grad4(0.12128480194602098, -0.4321472685365301, -0.4321472685365301, -0.7821684431180708), new Grad4(-0.508629699630796, 0.044802370851755174, 0.044802370851755174, -0.8586508742123365), new Grad4(0.044802370851755174, -0.508629699630796, 0.044802370851755174, -0.8586508742123365), new Grad4(0.044802370851755174, 0.044802370851755174, -0.508629699630796, -0.8586508742123365), new Grad4(-0.03381941603233842, -0.03381941603233842, -0.03381941603233842, -0.9982828964265062), new Grad4(-0.6740059517812944, -0.3239847771997537, -0.3239847771997537, 0.5794684678643381), new Grad4(-0.7504883828755602, -0.4004672082940195, 0.15296486218853164, 0.5029860367700724), new Grad4(-0.7504883828755602, 0.15296486218853164, -0.4004672082940195, 0.5029860367700724), new Grad4(-0.8828161875373585, 0.08164729285680945, 0.08164729285680945, 0.4553054119602712), new Grad4(-0.4553054119602712, -0.08164729285680945, -0.08164729285680945, 0.8828161875373585), new Grad4(-0.5029860367700724, -0.15296486218853164, 0.4004672082940195, 0.7504883828755602), new Grad4(-0.5029860367700724, 0.4004672082940195, -0.15296486218853164, 0.7504883828755602), new Grad4(-0.5794684678643381, 0.3239847771997537, 0.3239847771997537, 0.6740059517812944), new Grad4(-0.3239847771997537, -0.6740059517812944, -0.3239847771997537, 0.5794684678643381), new Grad4(-0.4004672082940195, -0.7504883828755602, 0.15296486218853164, 0.5029860367700724), new Grad4(0.15296486218853164, -0.7504883828755602, -0.4004672082940195, 0.5029860367700724), new Grad4(0.08164729285680945, -0.8828161875373585, 0.08164729285680945, 0.4553054119602712), new Grad4(-0.08164729285680945, -0.4553054119602712, -0.08164729285680945, 0.8828161875373585), new Grad4(-0.15296486218853164, -0.5029860367700724, 0.4004672082940195, 0.7504883828755602), new Grad4(0.4004672082940195, -0.5029860367700724, -0.15296486218853164, 0.7504883828755602), new Grad4(0.3239847771997537, -0.5794684678643381, 0.3239847771997537, 0.6740059517812944), new Grad4(-0.3239847771997537, -0.3239847771997537, -0.6740059517812944, 0.5794684678643381), new Grad4(-0.4004672082940195, 0.15296486218853164, -0.7504883828755602, 0.5029860367700724), new Grad4(0.15296486218853164, -0.4004672082940195, -0.7504883828755602, 0.5029860367700724), new Grad4(0.08164729285680945, 0.08164729285680945, -0.8828161875373585, 0.4553054119602712), new Grad4(-0.08164729285680945, -0.08164729285680945, -0.4553054119602712, 0.8828161875373585), new Grad4(-0.15296486218853164, 0.4004672082940195, -0.5029860367700724, 0.7504883828755602), new Grad4(0.4004672082940195, -0.15296486218853164, -0.5029860367700724, 0.7504883828755602), new Grad4(0.3239847771997537, 0.3239847771997537, -0.5794684678643381, 0.6740059517812944), new Grad4(-0.6740059517812944, -0.3239847771997537, 0.5794684678643381, -0.3239847771997537), new Grad4(-0.7504883828755602, -0.4004672082940195, 0.5029860367700724, 0.15296486218853164), new Grad4(-0.7504883828755602, 0.15296486218853164, 0.5029860367700724, -0.4004672082940195), new Grad4(-0.8828161875373585, 0.08164729285680945, 0.4553054119602712, 0.08164729285680945), new Grad4(-0.4553054119602712, -0.08164729285680945, 0.8828161875373585, -0.08164729285680945), new Grad4(-0.5029860367700724, -0.15296486218853164, 0.7504883828755602, 0.4004672082940195), new Grad4(-0.5029860367700724, 0.4004672082940195, 0.7504883828755602, -0.15296486218853164), new Grad4(-0.5794684678643381, 0.3239847771997537, 0.6740059517812944, 0.3239847771997537), new Grad4(-0.3239847771997537, -0.6740059517812944, 0.5794684678643381, -0.3239847771997537), new Grad4(-0.4004672082940195, -0.7504883828755602, 0.5029860367700724, 0.15296486218853164), new Grad4(0.15296486218853164, -0.7504883828755602, 0.5029860367700724, -0.4004672082940195), new Grad4(0.08164729285680945, -0.8828161875373585, 0.4553054119602712, 0.08164729285680945), new Grad4(-0.08164729285680945, -0.4553054119602712, 0.8828161875373585, -0.08164729285680945), new Grad4(-0.15296486218853164, -0.5029860367700724, 0.7504883828755602, 0.4004672082940195), new Grad4(0.4004672082940195, -0.5029860367700724, 0.7504883828755602, -0.15296486218853164), new Grad4(0.3239847771997537, -0.5794684678643381, 0.6740059517812944, 0.3239847771997537), new Grad4(-0.3239847771997537, -0.3239847771997537, 0.5794684678643381, -0.6740059517812944), new Grad4(-0.4004672082940195, 0.15296486218853164, 0.5029860367700724, -0.7504883828755602), new Grad4(0.15296486218853164, -0.4004672082940195, 0.5029860367700724, -0.7504883828755602), new Grad4(0.08164729285680945, 0.08164729285680945, 0.4553054119602712, -0.8828161875373585), new Grad4(-0.08164729285680945, -0.08164729285680945, 0.8828161875373585, -0.4553054119602712), new Grad4(-0.15296486218853164, 0.4004672082940195, 0.7504883828755602, -0.5029860367700724), new Grad4(0.4004672082940195, -0.15296486218853164, 0.7504883828755602, -0.5029860367700724), new Grad4(0.3239847771997537, 0.3239847771997537, 0.6740059517812944, -0.5794684678643381), new Grad4(-0.6740059517812944, 0.5794684678643381, -0.3239847771997537, -0.3239847771997537), new Grad4(-0.7504883828755602, 0.5029860367700724, -0.4004672082940195, 0.15296486218853164), new Grad4(-0.7504883828755602, 0.5029860367700724, 0.15296486218853164, -0.4004672082940195), new Grad4(-0.8828161875373585, 0.4553054119602712, 0.08164729285680945, 0.08164729285680945), new Grad4(-0.4553054119602712, 0.8828161875373585, -0.08164729285680945, -0.08164729285680945), new Grad4(-0.5029860367700724, 0.7504883828755602, -0.15296486218853164, 0.4004672082940195), new Grad4(-0.5029860367700724, 0.7504883828755602, 0.4004672082940195, -0.15296486218853164), new Grad4(-0.5794684678643381, 0.6740059517812944, 0.3239847771997537, 0.3239847771997537), new Grad4(-0.3239847771997537, 0.5794684678643381, -0.6740059517812944, -0.3239847771997537), new Grad4(-0.4004672082940195, 0.5029860367700724, -0.7504883828755602, 0.15296486218853164), new Grad4(0.15296486218853164, 0.5029860367700724, -0.7504883828755602, -0.4004672082940195), new Grad4(0.08164729285680945, 0.4553054119602712, -0.8828161875373585, 0.08164729285680945), new Grad4(-0.08164729285680945, 0.8828161875373585, -0.4553054119602712, -0.08164729285680945), new Grad4(-0.15296486218853164, 0.7504883828755602, -0.5029860367700724, 0.4004672082940195), new Grad4(0.4004672082940195, 0.7504883828755602, -0.5029860367700724, -0.15296486218853164), new Grad4(0.3239847771997537, 0.6740059517812944, -0.5794684678643381, 0.3239847771997537), new Grad4(-0.3239847771997537, 0.5794684678643381, -0.3239847771997537, -0.6740059517812944), new Grad4(-0.4004672082940195, 0.5029860367700724, 0.15296486218853164, -0.7504883828755602), new Grad4(0.15296486218853164, 0.5029860367700724, -0.4004672082940195, -0.7504883828755602), new Grad4(0.08164729285680945, 0.4553054119602712, 0.08164729285680945, -0.8828161875373585), new Grad4(-0.08164729285680945, 0.8828161875373585, -0.08164729285680945, -0.4553054119602712), new Grad4(-0.15296486218853164, 0.7504883828755602, 0.4004672082940195, -0.5029860367700724), new Grad4(0.4004672082940195, 0.7504883828755602, -0.15296486218853164, -0.5029860367700724), new Grad4(0.3239847771997537, 0.6740059517812944, 0.3239847771997537, -0.5794684678643381), new Grad4(0.5794684678643381, -0.6740059517812944, -0.3239847771997537, -0.3239847771997537), new Grad4(0.5029860367700724, -0.7504883828755602, -0.4004672082940195, 0.15296486218853164), new Grad4(0.5029860367700724, -0.7504883828755602, 0.15296486218853164, -0.4004672082940195), new Grad4(0.4553054119602712, -0.8828161875373585, 0.08164729285680945, 0.08164729285680945), new Grad4(0.8828161875373585, -0.4553054119602712, -0.08164729285680945, -0.08164729285680945), new Grad4(0.7504883828755602, -0.5029860367700724, -0.15296486218853164, 0.4004672082940195), new Grad4(0.7504883828755602, -0.5029860367700724, 0.4004672082940195, -0.15296486218853164), new Grad4(0.6740059517812944, -0.5794684678643381, 0.3239847771997537, 0.3239847771997537), new Grad4(0.5794684678643381, -0.3239847771997537, -0.6740059517812944, -0.3239847771997537), new Grad4(0.5029860367700724, -0.4004672082940195, -0.7504883828755602, 0.15296486218853164), new Grad4(0.5029860367700724, 0.15296486218853164, -0.7504883828755602, -0.4004672082940195), new Grad4(0.4553054119602712, 0.08164729285680945, -0.8828161875373585, 0.08164729285680945), new Grad4(0.8828161875373585, -0.08164729285680945, -0.4553054119602712, -0.08164729285680945), new Grad4(0.7504883828755602, -0.15296486218853164, -0.5029860367700724, 0.4004672082940195), new Grad4(0.7504883828755602, 0.4004672082940195, -0.5029860367700724, -0.15296486218853164), new Grad4(0.6740059517812944, 0.3239847771997537, -0.5794684678643381, 0.3239847771997537), new Grad4(0.5794684678643381, -0.3239847771997537, -0.3239847771997537, -0.6740059517812944), new Grad4(0.5029860367700724, -0.4004672082940195, 0.15296486218853164, -0.7504883828755602), new Grad4(0.5029860367700724, 0.15296486218853164, -0.4004672082940195, -0.7504883828755602), new Grad4(0.4553054119602712, 0.08164729285680945, 0.08164729285680945, -0.8828161875373585), new Grad4(0.8828161875373585, -0.08164729285680945, -0.08164729285680945, -0.4553054119602712), new Grad4(0.7504883828755602, -0.15296486218853164, 0.4004672082940195, -0.5029860367700724), new Grad4(0.7504883828755602, 0.4004672082940195, -0.15296486218853164, -0.5029860367700724), new Grad4(0.6740059517812944, 0.3239847771997537, 0.3239847771997537, -0.5794684678643381), new Grad4(0.03381941603233842, 0.03381941603233842, 0.03381941603233842, 0.9982828964265062), new Grad4(-0.044802370851755174, -0.044802370851755174, 0.508629699630796, 0.8586508742123365), new Grad4(-0.044802370851755174, 0.508629699630796, -0.044802370851755174, 0.8586508742123365), new Grad4(-0.12128480194602098, 0.4321472685365301, 0.4321472685365301, 0.7821684431180708), new Grad4(0.508629699630796, -0.044802370851755174, -0.044802370851755174, 0.8586508742123365), new Grad4(0.4321472685365301, -0.12128480194602098, 0.4321472685365301, 0.7821684431180708), new Grad4(0.4321472685365301, 0.4321472685365301, -0.12128480194602098, 0.7821684431180708), new Grad4(0.37968289875261624, 0.37968289875261624, 0.37968289875261624, 0.753341017856078), new Grad4(0.03381941603233842, 0.03381941603233842, 0.9982828964265062, 0.03381941603233842), new Grad4(-0.044802370851755174, 0.044802370851755174, 0.8586508742123365, 0.508629699630796), new Grad4(-0.044802370851755174, 0.508629699630796, 0.8586508742123365, -0.044802370851755174), new Grad4(-0.12128480194602098, 0.4321472685365301, 0.7821684431180708, 0.4321472685365301), new Grad4(0.508629699630796, -0.044802370851755174, 0.8586508742123365, -0.044802370851755174), new Grad4(0.4321472685365301, -0.12128480194602098, 0.7821684431180708, 0.4321472685365301), new Grad4(0.4321472685365301, 0.4321472685365301, 0.7821684431180708, -0.12128480194602098), new Grad4(0.37968289875261624, 0.37968289875261624, 0.753341017856078, 0.37968289875261624), new Grad4(0.03381941603233842, 0.9982828964265062, 0.03381941603233842, 0.03381941603233842), new Grad4(-0.044802370851755174, 0.8586508742123365, -0.044802370851755174, 0.508629699630796), new Grad4(-0.044802370851755174, 0.8586508742123365, 0.508629699630796, -0.044802370851755174), new Grad4(-0.12128480194602098, 0.7821684431180708, 0.4321472685365301, 0.4321472685365301), new Grad4(0.508629699630796, 0.8586508742123365, -0.044802370851755174, -0.044802370851755174), new Grad4(0.4321472685365301, 0.7821684431180708, -0.12128480194602098, 0.4321472685365301), new Grad4(0.4321472685365301, 0.7821684431180708, 0.4321472685365301, -0.12128480194602098), new Grad4(0.37968289875261624, 0.753341017856078, 0.37968289875261624, 0.37968289875261624), new Grad4(0.9982828964265062, 0.03381941603233842, 0.03381941603233842, 0.03381941603233842), new Grad4(0.8586508742123365, -0.044802370851755174, -0.044802370851755174, 0.508629699630796), new Grad4(0.8586508742123365, -0.044802370851755174, 0.508629699630796, -0.044802370851755174), new Grad4(0.7821684431180708, -0.12128480194602098, 0.4321472685365301, 0.4321472685365301), new Grad4(0.8586508742123365, 0.508629699630796, -0.044802370851755174, -0.044802370851755174), new Grad4(0.7821684431180708, 0.4321472685365301, -0.12128480194602098, 0.4321472685365301), new Grad4(0.7821684431180708, 0.4321472685365301, 0.4321472685365301, -0.12128480194602098), new Grad4(0.753341017856078, 0.37968289875261624, 0.37968289875261624, 0.37968289875261624)};
        for (i = 0; i < grad4.length; ++i) {
            grad4[i].dx /= 0.11127401889945551;
            grad4[i].dy /= 0.11127401889945551;
            grad4[i].dz /= 0.11127401889945551;
            grad4[i].dw /= 0.11127401889945551;
        }
        for (i = 0; i < 2048; ++i) {
            OpenSimplex2S.GRADIENTS_4D[i] = grad4[i % grad4.length];
        }
    }

    public static class Values3D1 {
        public double value;
        public double dx;
        public double dy;
        public double dz;
    }

    public static class Values2D1 {
        public double value;
        public double dx;
        public double dy;
    }

    public static class Grad4 {
        double dx;
        double dy;
        double dz;
        double dw;

        public Grad4(double dx, double dy, double dz, double dw) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.dw = dw;
        }
    }

    public static class Grad3 {
        double dx;
        double dy;
        double dz;

        public Grad3(double dx, double dy, double dz) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }
    }

    public static class Grad2 {
        double dx;
        double dy;

        public Grad2(double dx, double dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }

    private static class LatticePoint4D {
        int xsv;
        int ysv;
        int zsv;
        int wsv;
        double dx;
        double dy;
        double dz;
        double dw;

        public LatticePoint4D(int xsv, int ysv, int zsv, int wsv) {
            this.xsv = xsv;
            this.ysv = ysv;
            this.zsv = zsv;
            this.wsv = wsv;
            double ssv = (double)(xsv + ysv + zsv + wsv) * -0.138196601125011;
            this.dx = (double)(-xsv) - ssv;
            this.dy = (double)(-ysv) - ssv;
            this.dz = (double)(-zsv) - ssv;
            this.dw = (double)(-wsv) - ssv;
        }
    }

    private static class LatticePoint3D {
        public double dxr;
        public double dyr;
        public double dzr;
        public int xrv;
        public int yrv;
        public int zrv;
        LatticePoint3D nextOnFailure;
        LatticePoint3D nextOnSuccess;

        public LatticePoint3D(int xrv, int yrv, int zrv, int lattice) {
            this.dxr = (double)(-xrv) + (double)lattice * 0.5;
            this.dyr = (double)(-yrv) + (double)lattice * 0.5;
            this.dzr = (double)(-zrv) + (double)lattice * 0.5;
            this.xrv = xrv + lattice * 1024;
            this.yrv = yrv + lattice * 1024;
            this.zrv = zrv + lattice * 1024;
        }
    }

    private static class LatticePoint2D {
        int xsv;
        int ysv;
        double dx;
        double dy;

        public LatticePoint2D(int xsv, int ysv) {
            this.xsv = xsv;
            this.ysv = ysv;
            double ssv = (double)(xsv + ysv) * -0.211324865405187;
            this.dx = (double)(-xsv) - ssv;
            this.dy = (double)(-ysv) - ssv;
        }
    }
}

