/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.generation.noise;

import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class Xorshift {
    private static final int SEED_TABLE_SPACE = 1024;
    private static final int SEED_TABLE_SIZE = 3072;
    private final long[] seeds;

    public static Xorshift create() {
        return new Xorshift(ThreadLocalRandom.current().nextLong());
    }

    public static Xorshift create(long seed) {
        return new Xorshift(seed);
    }

    private Xorshift(long seed) {
        Random random = new Random(seed);
        this.seeds = new long[3072];
        for (int i = 0; i < 3072; ++i) {
            this.seeds[i] = random.nextLong();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Xorshift) {
            Xorshift o = (Xorshift)obj;
            return Objects.equals(this.seeds, o.seeds);
        }
        return false;
    }

    public Instance getInstance() {
        return new Instance();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.seeds});
    }

    public static void main(String ... args) {
        int i;
        Xorshift xorshift = Xorshift.create(0L);
        Instance r = xorshift.getInstance();
        Stopwatch sw = Stopwatch.createStarted();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i2 = 0; i2 < Integer.MAX_VALUE; ++i2) {
            double d = r.nextDouble();
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        System.out.printf("Making %d doubles took %s\n", Integer.MAX_VALUE, sw);
        System.out.printf("min double: %1.40f\n", min);
        System.out.printf("max double: %1.40f\n", max);
        int[] bins = new int[100];
        for (i = 0; i < Integer.MAX_VALUE; ++i) {
            int b;
            double d = r.nextDouble();
            int n = b = (int)(d * 100.0);
            bins[n] = bins[n] + 1;
        }
        System.out.println("Histogram of doubles:");
        for (i = 0; i < 100; ++i) {
            System.out.printf("bin %d:\t%d\n", i, bins[i]);
        }
    }

    public final class Instance {
        private long x;
        private long y;
        private long z;

        private Instance() {
            this.setSeed(0L, 0L, 0L);
        }

        public double nextDouble() {
            return (double)(this.nextLong() >>> 2) * 2.168404344971009E-19;
        }

        public long nextLong() {
            long t = this.x ^ this.x << 13;
            this.x = this.y;
            this.y = this.z;
            this.z = this.z ^ this.z >>> 3 ^ (t ^ t >>> 19);
            return this.z;
        }

        public void setSeed(long x, long y, long z) {
            this.x = Xorshift.this.seeds[(int)(Math.abs(x) % 1024L)];
            this.y = Xorshift.this.seeds[(int)(Math.abs(y) % 1024L) + 1024];
            this.z = Xorshift.this.seeds[(int)(Math.abs(z) % 1024L) + 1024 + 1024];
            for (int i = 0; i < 5; ++i) {
                this.nextLong();
            }
        }
    }
}

