/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.item;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.EnderPouchBakery;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.generation.IBakery;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEnderPouch
extends Item
implements IBakeryProvider {
    public ItemEnderPouch() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Frequency frequency = Frequency.readFromStack(stack);
        if (frequency.hasOwner()) {
            tooltip.add(frequency.getOwnerName());
        }
        tooltip.add(frequency.getTooltip());
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.PASS;
        }
        TileEntity tile = world.func_175625_s(context.func_195995_a());
        if (tile instanceof TileEnderChest && context.func_195999_j().func_213453_ef()) {
            TileEnderChest chest = (TileEnderChest)tile;
            Frequency frequency = chest.getFrequency().copy();
            if (EnderStorageConfig.anarchyMode && (frequency.owner == null || !frequency.owner.equals(context.func_195999_j().func_110124_au()))) {
                frequency.setOwner(null);
            }
            frequency.writeToStack(stack);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_213453_ef()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            Frequency frequency = Frequency.readFromStack(stack);
            EnderStorageManager.instance(world.field_72995_K).getStorage(frequency, EnderItemStorage.TYPE).openContainer((ServerPlayerEntity)player, (ITextComponent)new TranslationTextComponent(stack.func_77977_a(), new Object[0]));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakery getBakery() {
        return EnderPouchBakery.INSTANCE;
    }
}

