/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.network.Connection;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.types.ParticleType;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ForgeMod {
    protected final Logger logger;
    protected final Connection connection;
    protected IForgeRegistry currentRegistry;

    public abstract String getId();

    protected ForgeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(event -> this.commonInit());
        modEventBus.addListener(event -> this.commonPostInit());
        modEventBus.addListener(event -> this.onRegisterEvent(event.getRegistry()));
        forgeEventBus.addListener(event -> this.updateReloadedTags());
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit);
        forgeEventBus.addListener(event -> this.dedicatedServerInit((DedicatedServer)event.getServerSupplier().get()));
        forgeEventBus.addListener(event -> this.serverAboutToStart(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStarting(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStopped(event.getServer()));
        forgeEventBus.addListener(event -> this.registerCommands(ServerCommand.createFor(this, event.getServer())));
        if (EffectiveSide.get().isClient()) {
            modEventBus.addListener(event -> this.clientInit());
            modEventBus.addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getModelRegistry())));
            modEventBus.addListener(event -> this.clientRegisterParticleFactories(Minecraft.func_71410_x().field_71452_i));
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit);
        }
        this.logger = LogManager.getLogger((String)this.getId());
        this.connection = new Connection(this.getId());
    }

    public abstract void commonInit();

    public abstract void commonPostInit();

    public abstract void commonConfigInit(ConfigValueBuilder var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void clientConfigInit(ConfigValueBuilder var1);

    public abstract void registerBlocks();

    public abstract void registerItems();

    public abstract void registerEntities();

    public abstract void registerTiles();

    public void registerParticles() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleFactories(ParticleManager manager) {
    }

    public void registerCommands(ServerCommand command) {
    }

    public void updateReloadedTags() {
    }

    protected void dedicatedServerInit(DedicatedServer server) {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected <MSG extends ForgeNetMsg<MSG>> void registerNetMessage(Supplier<MSG> factory) {
        this.getConnection().registerNetMessage((ForgeNetMsg)factory.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityType, renderFactory);
    }

    protected ResourceLocation createRegNameFor(ForgeRegistryEntry<?> entry) {
        String name = IForgeUnit.getClassRegName(entry.getClass());
        ResourceLocation regName = new ResourceLocation(this.getId(), name);
        return regName;
    }

    protected void onRegisterEvent(IForgeRegistry<?> registry) {
        this.currentRegistry = registry;
        Class type = registry.getRegistrySuperType();
        if (type == Block.class) {
            this.registerBlocks();
        } else if (type == Item.class) {
            this.registerItems();
        } else if (type == EntityType.class) {
            this.registerEntities();
        } else if (type.isAssignableFrom(ParticleType.class)) {
            this.registerParticles();
        } else if (type == TileEntityType.class) {
            this.registerTiles();
        }
    }

    protected <E extends IForgeRegistryEntry<E>> E registerForgeEntry(E entry, String name) {
        if (entry instanceof IForgeUnit) {
            ((IForgeUnit)entry).saveConfig();
        }
        if (entry.getRegistryName() == null) {
            ResourceLocation regName = new ResourceLocation(this.getId(), name);
            entry.setRegistryName(regName);
        }
        this.currentRegistry.register(entry);
        return entry;
    }

    protected <T extends Block> T registerBlock(T block) {
        this.registerForgeEntry((IForgeRegistryEntry)block, block.getRegistryName().func_110623_a());
        return block;
    }

    protected <T extends Item> T registerItem(T item) {
        this.registerForgeEntry((IForgeRegistryEntry)item, item.getRegistryName().func_110623_a());
        return item;
    }

    protected <T extends BlockItem> T registerBlockItem(T item) {
        String name = item.func_179223_d().getRegistryName().func_110623_a();
        this.registerForgeEntry((IForgeRegistryEntry)item, name);
        return item;
    }

    protected <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder) {
        String id = new ResourceLocation(this.getId(), name).toString();
        EntityType type = builder.func_206830_a(id);
        this.registerForgeEntry(type, name);
        return type;
    }

    protected <T extends TileEntity> TileEntityType<T> registerTile(String name, TileEntityType.Builder<T> builder) {
        TileEntityType type = builder.func_206865_a(null);
        this.registerForgeEntry(type, name);
        return type;
    }

    protected <T extends IParticleData> ParticleType<T> registerParticle(String name, ParticleType.Builder<T> builder) {
        ParticleType<T> type = builder.build();
        this.registerForgeEntry((IForgeRegistryEntry)type, name);
        return type;
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    public ResourceLocation toResLoc(String path) {
        return new ResourceLocation(this.getId(), path);
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ModLoadingContext.get().registerConfig(type, value.builder.build());
    }

    public static class ConfigValueBuilder {
        public final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ForgeConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ForgeConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.min.intValue(), bounds.max.intValue());
        }

        public ForgeConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            return this.builder.defineInRange(path, (double)defaultValue, (double)bounds.min.floatValue(), (double)bounds.max.floatValue());
        }
    }
}

