/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicMinoBlue
extends LogicBase {
    public boolean selectA = false;
    public boolean selectB = false;
    public Vector2 positionA = new Vector2(0, 0);
    public Vector2 positionB = new Vector2(0, 0);
    public int timer = 0;

    public LogicMinoBlue(int tableID) {
        super(tableID, 17, 9);
    }

    @Override
    public void start2() {
        this.scoreLevel = 1;
        this.scoreLives = 8;
        this.selectA = false;
        this.selectB = false;
        this.timer = 0;
        this.positionA.set(-1, -1);
        this.positionB.set(-1, -1);
        this.commandCreateGrid();
    }

    public void restart() {
        this.turnstate = 2;
        ++this.scoreLevel;
        this.scoreLives += this.scoreLevel * 2;
        this.selectA = false;
        this.selectB = false;
        this.timer = 0;
        this.positionA.set(-1, -1);
        this.positionB.set(-1, -1);
        this.commandCreateGrid();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else {
            this.clickMino(action % 17, action / 17);
        }
    }

    @Override
    public void updateLogic() {
        if (this.timer == -1) {
            if (this.grid[this.positionA.X][this.positionA.Y] == this.grid[this.positionB.X][this.positionB.Y]) {
                this.grid[this.positionA.X][this.positionA.Y] = -1;
                this.grid[this.positionB.X][this.positionB.Y] = -1;
            } else {
                --this.scoreLives;
            }
            boolean temp = false;
            for (int x = 0; x < 17; ++x) {
                for (int y = 0; y < 9; ++y) {
                    if (this.grid[x][y] == -1) continue;
                    temp = true;
                }
            }
            if (!temp) {
                this.turnstate = 3;
                this.scorePoint += this.scoreLevel * 4;
            } else if (this.scoreLives <= 0) {
                this.turnstate = 4;
                this.scorePoint /= 2;
            }
            this.selectA = false;
            this.selectB = false;
            this.positionA.set(-1, -1);
            this.positionB.set(-1, -1);
            this.timer = 0;
        }
    }

    @Override
    public void updateMotion() {
        if (this.timer > 0) {
            this.timer -= 10;
            if (this.timer <= 0) {
                this.timer = -1;
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.selectA = compound.func_74767_n("selecta");
        this.selectB = compound.func_74767_n("selectb");
        this.positionA.set(compound.func_74762_e("positionax"), compound.func_74762_e("positionay"));
        this.positionA.set(compound.func_74762_e("positionbx"), compound.func_74762_e("positionby"));
        this.timer = compound.func_74762_e("timer");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        compound.func_74757_a("selecta", this.selectA);
        compound.func_74757_a("selectb", this.selectB);
        compound.func_74768_a("positionax", this.positionA.X);
        compound.func_74768_a("positionay", this.positionA.Y);
        compound.func_74768_a("positionbx", this.positionB.X);
        compound.func_74768_a("positionby", this.positionB.Y);
        compound.func_74768_a("timer", this.timer);
        return compound;
    }

    private void clickMino(int x, int y) {
        if (!this.selectA) {
            if (this.grid[x][y] != -1) {
                this.selectA = true;
                this.positionA.set(x, y);
            }
        } else if (!this.selectB && this.grid[x][y] != -1 && !this.positionA.matches(x, y)) {
            this.selectB = true;
            this.positionB.set(x, y);
            this.timer = 200 - this.scoreLevel * 10;
        }
    }

    private void commandCreateGrid() {
        int filler;
        for (int x = 0; x < 17; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.grid[x][y] = -1;
            }
        }
        int max = this.tableID == 1 ? 80 : 152;
        int filler2 = filler = this.scoreLevel * 4 < max ? this.scoreLevel * 4 : max;
        int[] color = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        while (filler > 0) {
            int z;
            int n = z = this.RANDOM.nextInt(8);
            color[n] = color[n] + 2;
            filler -= 2;
        }
        block3: while (filler2 > 0) {
            int y;
            int x = this.RANDOM.nextInt(this.tableID == 1 ? 9 : 17) + (this.tableID == 1 ? 4 : 0);
            if (this.grid[x][y = this.RANDOM.nextInt(9)] != -1) continue;
            for (int i = 0; i < 8; ++i) {
                if (color[i] <= 0) continue;
                this.grid[x][y] = i;
                int n = i;
                color[n] = color[n] - 1;
                --filler2;
                continue block3;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 33;
    }
}

